//two servos connected to a picavet (kite aerial photography)
//with auto movement of the servos
//
//Rein Velt (rein@mechanicape.com)

#include <Servo.h>
Servo servopan;
Servo servotilt;

int panMinimum=0;
int panAngle=90;
int panMaximum=190;

int tiltMinimum=0;
int tiltAngle=90;
int tiltMaximum=100;//we dont want to look up, only forward and down

int panIncrement=1;
int tiltIncrement=10;
int delayTime=1000; 
boolean ledStatus=LOW;

void setup()
{
  Serial.begin(38400);
  servopan.attach(9);
  servotilt.attach(10);

}


void LedToggle()
{
     if (ledStatus==LOW)
     {
       ledStatus=HIGH;
     }
     else
     {
       ledStatus=LOW;
     }
     digitalWrite(13,ledStatus);
}

void loop()
{
  delayTime=potmeterToDelayTime();
  
  if (delayTime>0)
  {
      panAngle=panAngle+panIncrement;
    
      //do the pan stuff (moving the servo from left to right and vice versa)
      if (panAngle>=panMaximum || panAngle<=panMinimum)
      {
        panIncrement=panIncrement*-1;
        panAngle=panAngle+panIncrement;
        tiltAngle=tiltAngle+tiltIncrement;
      }
    
      //do the tilt stuff (moving the servo from up to down and vice versa)
      if (tiltAngle>=tiltMaximum || tiltAngle<=tiltMinimum)
      {
        tiltIncrement=tiltIncrement*-1;
        tiltAngle=tiltAngle+tiltIncrement;
      }
    
      servopan.write(panAngle);
      servotilt.write(tiltAngle);
      LedToggle();
  }
  
  delay(delayTime);
}

int potmeterToDelayTime()
{
  int delayTime=map(analogRead(0),0,1024,10,10000);
  return delayTime;
}
