#include <Wire.h>



#define pinFrontIr          4
#define pinIrRx             5
#define pinServoLeft        8
#define pinServoRight       9
#define pinServoSweep       10
#define pinSpeaker          11

#define pinHeartbeat        13

#define sCommandNone        -1
#define sCommandIdle        0
#define sCommandStop        1
#define sCommandForward     2
#define sCommandBackward    3
#define sCommandLeft        4
#define sCommandRight       5
#define sCommandCollission  8

#define sCollissionDetected 0
#define sServoDelay         5 //milliseconds
#define sServoMinPulse      1000 //microseconds
#define sServoMidPulse      1502 //microseconds
#define sServoMaxPulse      2000 //microseconds   


#define srfAddress 0x70                           // Address of the SRF08
#define cmdByte 0x00                              // Command byte
#define rangeByte 0x02                            // Byte for start of ranging data

#define autonomous          true

int sequenceCounter=0;
int servoPulse=sServoMidPulse;
int servoDirection=1;

void setup()
{
    delay(2000);
    Serial.begin(57600);
    pinMode(pinServoLeft,OUTPUT);
    pinMode(pinServoRight,OUTPUT);
    tone(pinSpeaker,1200,1000);
    digitalWrite(pinServoLeft,LOW);
    digitalWrite(pinServoRight,LOW);

    Wire.begin();
    commandIdle();
}


void loop()
{
  sequenceCounter++;
  
  writeHeartbeatLed();
  float collission=readSensors();
  tone(pinSpeaker, collission*10,100);
  Serial.println(collission);
  if (collission>60)
  {
     commandMoveForward();
  
     for (int i=0;i<2000;i++)
     {
       tone(pinSpeaker,collission*8,50);
       tone(pinSpeaker,random(2000),50);
     }
  }
  else
  {
       commandIdle();
   
       for (int i=0;i<r;i++)
       {
        tone(pinSpeaker,i*10,10);
        delay(1);
       }
       commandTurnRight();
  }
  //int range=getRange();
  int range=0;
  //delay(200);
  if (servoPulse==sServoMaxPulse)
  {
      servoPulse=sServoMinPulse ;
  }
  else
  {
    servoPulse=sServoMaxPulse;
  }
  
  digitalWrite(pinServoSweep,HIGH);
   delayMicroseconds(servoPulse);
   digitalWrite(pinServoSweep,LOW);
   delay(1000);
}


void writeHeartbeatLed()
{
  int heartbeat=sequenceCounter%2;
  if (heartbeat==0)
  {
      digitalWrite(pinHeartbeat,LOW);
  }
  else
  {
    digitalWrite(pinHeartbeat,HIGH);
  }
}

float readSensors()
{
    //delay(90);
    float volts = float(analogRead(0))*0.0048828125;;   // value from sensor * (5/1024) - if running 3.3.volts then change 5 to 3.3
    float distance = (65*pow(volts, -1.10))/2;          // worked out from graph 65 = theretical distance / (1/Volts)S - luckylarry.co.uk
    return distance;
}


//MOTO FUNCTIONS

void commandMoveForward()
{
  setServo(pinServoLeft,1,0);
  setServo(pinServoRight,1 ,1); //reversed
}

void commandMoveBackward()
{
  setServo(pinServoLeft,-1,0);
  setServo(pinServoRight,-1 ,1); //reversed
}

void commandTurnLeft()
{
  setServo(pinServoLeft,-1,0);
  setServo(pinServoRight,1,1); //reversed
}

void commandTurnRight()
{
  setServo(pinServoLeft,1,0);
  setServo(pinServoRight,-1,1); //reversed
}

void commandStop()
{
  setServo(pinServoLeft,0,0);
  setServo(pinServoRight,0,1); //reversed
}


void commandIdle()
{

  setServo(pinServoLeft,0,0); //?
  setServo(pinServoRight,0,1); //reversed

}



void setServo(int servoPin,int mode,int invert)
{
   //Servo servo;
   int pulseLength=0;
   if (invert==1)
   { 
     //invert (mirrored)
     mode=mode*-1;
   }
   switch (mode)
   {
      case 1:  pulseLength=sServoMaxPulse;  break; //100 forward
      case 0: 
              { int plm=(sequenceCounter%3)-3; 
              pulseLength=sServoMidPulse+plm;
              }  
              break; //1500; break; //neutral/stop
      case -1: pulseLength=sServoMinPulse;  break; //2000 backward
   }
  
   if (mode!=10)
   {
     digitalWrite(servoPin,HIGH);
     delayMicroseconds(pulseLength);
     digitalWrite(servoPin,LOW);
     delay(sServoDelay);
   }
   else
   {
      analogWrite(servoPin,0);
      delay(sServoDelay);
   }
     
   
}


int serialReadCommand()
{
  int command=sCommandNone;
  if (Serial.available()>2)
  {
     int byte1=Serial.read();
     int byte2=Serial.read();
     int byte3=Serial.read();
     
     if (byte1=='M' && byte3==10)
     {
       command=byte2-48;
       Serial.print(char(command+48));
     }    
  } 
  //else
  //{
  //  delay(100);
  //}
  return command;
}




