/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbPixelReader_BYTE1D_X8R8G8B8_32
implements INyARRgbPixelReader {
    protected byte[] _ref_buf;
    private NyARIntSize _size;

    public NyARRgbPixelReader_BYTE1D_X8R8G8B8_32(byte[] i_buf, NyARIntSize i_size) {
        this._ref_buf = i_buf;
        this._size = i_size;
    }

    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        byte[] ref_buf = this._ref_buf;
        int bp = (i_x + i_y * this._size.w) * 4;
        o_rgb[0] = ref_buf[bp + 1] & 0xFF;
        o_rgb[1] = ref_buf[bp + 2] & 0xFF;
        o_rgb[2] = ref_buf[bp + 3] & 0xFF;
    }

    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._size.w;
        byte[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int bp = (i_x[i] + i_y[i] * width) * 4;
            o_rgb[i * 3 + 0] = ref_buf[bp + 1] & 0xFF;
            o_rgb[i * 3 + 1] = ref_buf[bp + 2] & 0xFF;
            o_rgb[i * 3 + 2] = ref_buf[bp + 3] & 0xFF;
            --i;
        }
    }

    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        NyARException.notImplement();
    }

    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    public void switchBuffer(Object i_ref_buffer) throws NyARException {
        assert (((byte[])i_ref_buffer).length >= this._size.w * this._size.h * 4);
        this._ref_buf = (byte[])i_ref_buffer;
    }
}

