/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRasterFilter_Rgb2Gs;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_Rgb2Gs_RgbCube
implements INyARRasterFilter_Rgb2Gs {
    private IdoFilterImpl _dofilterimpl;

    public NyARRasterFilter_Rgb2Gs_RgbCube(int i_in_raster_type) throws NyARException {
        if (!this.initInstance(i_in_raster_type, 262145)) {
            throw new NyARException();
        }
    }

    public NyARRasterFilter_Rgb2Gs_RgbCube(int i_in_raster_type, int i_out_raster) throws NyARException {
        if (!this.initInstance(i_in_raster_type, i_out_raster)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_in_raster_type, int i_out_raster_type) {
        block0 : switch (i_out_raster_type) {
            case 262145: {
                switch (i_in_raster_type) {
                    case 65537: 
                    case 65538: {
                        this._dofilterimpl = new IdoFilterImpl_BYTE1D_B8G8R8_24();
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void doFilter(INyARRgbRaster i_input, NyARGrayscaleRaster i_output) throws NyARException {
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        this._dofilterimpl.doFilter(i_input, i_output, i_input.getSize());
    }

    static interface IdoFilterImpl {
        public void doFilter(INyARRaster var1, INyARRaster var2, NyARIntSize var3) throws NyARException;
    }

    class IdoFilterImpl_BYTE1D_B8G8R8_24
    implements IdoFilterImpl {
        IdoFilterImpl_BYTE1D_B8G8R8_24() {
        }

        public void doFilter(INyARRaster i_input, INyARRaster i_output, NyARIntSize i_size) throws NyARException {
            assert (i_input.isEqualBufferType(65538) || i_input.isEqualBufferType(65537));
            assert (i_output.isEqualBufferType(262145));
            int[] out_buf = (int[])i_output.getBuffer();
            byte[] in_buf = (byte[])i_input.getBuffer();
            int bp = 0;
            int y = 0;
            while (y < i_size.h) {
                int x = 0;
                while (x < i_size.w) {
                    out_buf[y * i_size.w + x] = (in_buf[bp] & 0xFF) * (in_buf[bp + 1] & 0xFF) * (in_buf[bp + 2] & 0xFF) >> 16;
                    bp += 3;
                    ++x;
                }
                ++y;
            }
        }
    }
}

