/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_O3;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_Perspective_O2;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.NyARRasterFilter_ARToolkitThreshold;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_ARToolKit;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat_ARToolKit;
import jp.nyatla.nyartoolkit.detector.NyARCustomSingleDetectMarker;

public class NyARSingleDetectMarker
extends NyARCustomSingleDetectMarker {
    public static final int PF_ARTOOLKIT_COMPATIBLE = 1;
    public static final int PF_NYARTOOLKIT = 2;
    public static final int PF_NYARTOOLKIT_ARTOOLKIT_FITTING = 100;
    public static final int PF_TEST2 = 201;

    public NyARSingleDetectMarker(NyARParam i_param, NyARCode i_code, double i_marker_width, int i_input_raster_type, int i_profile_id) throws NyARException {
        this.initialize(i_param, i_code, i_marker_width, i_input_raster_type, i_profile_id);
    }

    public NyARSingleDetectMarker(NyARParam i_param, NyARCode i_code, double i_marker_width, int i_input_raster_type) throws NyARException {
        this.initialize(i_param, i_code, i_marker_width, i_input_raster_type, 2);
    }

    private void initialize(NyARParam i_ref_param, NyARCode i_ref_code, double i_marker_width, int i_input_raster_type, int i_profile_id) throws NyARException {
        INyARTransMat transmat_inst;
        NyARSquareContourDetector sqdetect_inst;
        INyARColorPatt patt_inst;
        NyARRasterFilter_ARToolkitThreshold th = new NyARRasterFilter_ARToolkitThreshold(100, i_input_raster_type);
        switch (i_profile_id) {
            case 1: {
                patt_inst = new NyARColorPatt_O3(i_ref_code.getWidth(), i_ref_code.getHeight());
                sqdetect_inst = new NyARSquareContourDetector_ARToolKit(i_ref_param.getDistortionFactor(), i_ref_param.getScreenSize());
                transmat_inst = new NyARTransMat_ARToolKit(i_ref_param);
                break;
            }
            case 100: {
                patt_inst = new NyARColorPatt_Perspective_O2(i_ref_code.getWidth(), i_ref_code.getHeight(), 4, 25);
                sqdetect_inst = new NyARSquareContourDetector_Rle(i_ref_param.getDistortionFactor(), i_ref_param.getScreenSize());
                transmat_inst = new NyARTransMat_ARToolKit(i_ref_param);
                break;
            }
            case 2: {
                patt_inst = new NyARColorPatt_Perspective_O2(i_ref_code.getWidth(), i_ref_code.getHeight(), 4, 25);
                sqdetect_inst = new NyARSquareContourDetector_Rle(i_ref_param.getDistortionFactor(), i_ref_param.getScreenSize());
                transmat_inst = new NyARTransMat(i_ref_param);
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        super.initInstance(patt_inst, sqdetect_inst, transmat_inst, th, i_ref_param, i_ref_code, i_marker_width);
    }

    public boolean detectMarkerLite(INyARRgbRaster i_raster, int i_threshold) throws NyARException {
        ((NyARRasterFilter_ARToolkitThreshold)this._tobin_filter).setThreshold(i_threshold);
        return super.detectMarkerLite(i_raster);
    }
}

