/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.JnaLibLoaderChain;
import codeanticode.gsvideo.LibraryPath;
import java.io.File;
import org.gstreamer.Gst;
import org.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;

public class GSVideo
implements PConstants {
    protected static long INSTANCES_COUNT = 0L;
    protected static String gstreamerBinPath = "";
    protected static String gstreamerPluginsPath = "";
    public static boolean useGStreamerDefaultContext = false;
    public static boolean forceGlobalGstreamer = false;
    public static boolean useGlobalGstreamer = false;

    public static void init() {
        if (INSTANCES_COUNT == 0L) {
            Registry reg;
            boolean res;
            JnaLibLoaderChain jnaLibLoaderChain;
            if (forceGlobalGstreamer) {
                useGlobalGstreamer = true;
            } else {
                GSVideo.lookForGlobalGStreamer();
            }
            if (PApplet.platform == 3) {
                GSVideo.setLinuxPath();
            } else if (PApplet.platform == 1) {
                GSVideo.setWindowsPath();
            } else if (PApplet.platform == 2) {
                GSVideo.setMacOSXPath();
            }
            if (!gstreamerBinPath.equals("")) {
                System.setProperty("jna.library.path", gstreamerBinPath);
            }
            if (PApplet.platform == 1 && !useGlobalGstreamer) {
                jnaLibLoaderChain = JnaLibLoaderChain.getInstance();
            }
            if (PApplet.platform == 2 && !useGlobalGstreamer) {
                jnaLibLoaderChain = JnaLibLoaderChain.getInstance();
            }
            String[] args = new String[]{""};
            Gst.setUseDefaultContext((boolean)useGStreamerDefaultContext);
            Gst.init((String)"GSVideo", (String[])args);
            if (!gstreamerPluginsPath.equals("") && !(res = (reg = Registry.getDefault()).scanPath(gstreamerPluginsPath))) {
                System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginsPath);
            }
        }
        ++INSTANCES_COUNT;
    }

    public static void lookForGlobalGStreamer() {
        if (PApplet.platform == 3) {
            File libPath = new File("/usr/lib");
            String[] files = libPath.list();
            int i = 0;
            while (i < files.length) {
                if (-1 < files[i].indexOf("libgstreamer")) {
                    useGlobalGstreamer = true;
                    return;
                }
                ++i;
            }
            useGlobalGstreamer = false;
        } else {
            String gst_plugin_path = System.getenv("GST_PLUGIN_PATH");
            useGlobalGstreamer = gst_plugin_path != null && !gst_plugin_path.equals("");
        }
    }

    public static void setLinuxPath() {
        if (useGlobalGstreamer) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            LibraryPath libPath = new LibraryPath();
            String path = libPath.get();
            gstreamerBinPath = String.valueOf(path) + "/gstreamer/linux";
            gstreamerPluginsPath = String.valueOf(path) + "/gstreamer/linux/plugins";
        }
    }

    public static void setWindowsPath() {
        if (useGlobalGstreamer) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            LibraryPath libPath = new LibraryPath();
            String path = libPath.get();
            gstreamerBinPath = String.valueOf(path) + "\\gstreamer\\win";
            gstreamerPluginsPath = String.valueOf(path) + "\\gstreamer\\win\\plugins";
        }
    }

    public static void setMacOSXPath() {
        if (useGlobalGstreamer) {
            gstreamerBinPath = "/opt/local/lib:/System/Library/GStreamer/lib";
            gstreamerPluginsPath = "";
        } else {
            LibraryPath libPath = new LibraryPath();
            String path = libPath.get();
            gstreamerBinPath = String.valueOf(path) + "/gstreamer/macosx";
            gstreamerPluginsPath = String.valueOf(path) + "/macosx/gstreamer/plugins";
        }
    }
}

