/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.elements.RGBDataSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSPipeline
extends PImage
implements PConstants {
    Method pipelineEventMethod;
    boolean available;
    boolean firstFrame = true;
    int pipeWidth;
    int pipeHeight;
    IntBuffer pipePixels;
    Pipeline gpipe;
    RGBDataSink videoSink;
    protected boolean newFrame;

    public GSPipeline(PApplet parent, String pipeStr) {
        super(1, 1, 1);
        this.parent = parent;
        this.gpipe = null;
        GSVideo.init();
        parent.registerDispose((Object)this);
        try {
            this.pipelineEventMethod = parent.getClass().getMethod("pipelineEvent", GSPipeline.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int idx = pipeStr.lastIndexOf(33);
        String lastElem = pipeStr.substring(idx + 1, pipeStr.length()).trim();
        String[] parts = lastElem.split(" ");
        String lastElemName = parts.length > 0 ? parts[0] : "";
        boolean fakeSink = lastElemName.equals("fakesink");
        boolean fileSink = lastElemName.equals("filesink");
        if (fakeSink || fileSink) {
            this.gpipe = Pipeline.launch((String)pipeStr);
        } else {
            this.gpipe = Pipeline.launch((String)(String.valueOf(pipeStr) + " ! fakesink name=VideoSink"));
            this.videoSink = new RGBDataSink("rgb", this.gpipe, new RGBDataSink.Listener(){

                public void rgbFrame(int w, int h, IntBuffer buffer) {
                    GSPipeline.this.invokeEvent(w, h, buffer);
                }
            });
        }
        this.gpipe.setState(State.PLAYING);
    }

    public boolean available() {
        return this.available;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public void oldFrame() {
        this.newFrame = false;
    }

    public void read() {
        if (this.firstFrame) {
            super.init(this.pipeWidth, this.pipeHeight, 1);
            this.loadPixels();
            this.firstFrame = false;
        }
        this.pipePixels.get(this.pixels);
        this.updatePixels();
        this.available = false;
        this.newFrame = true;
    }

    public void resume() {
        this.gpipe.setState(State.PLAYING);
    }

    public void stop() {
        this.gpipe.setState(State.PAUSED);
    }

    protected void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.pipeWidth = w;
        this.pipeHeight = h;
        this.pipePixels = buffer;
        if (this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke((Object)this.parent, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling pipelineEvent() for GSPipeline");
                e.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }

    public void dispose() {
    }
}

