/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bus;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSMovie
extends PImage
implements PConstants {
    FrameReader reader;
    Thread readThread;
    protected Method movieEventMethod;
    protected String filename;
    protected boolean play;
    protected boolean repeat;
    protected boolean available;
    protected boolean newFrame;
    protected boolean firstFrame;
    protected int fps;
    protected float rate;
    protected int movieWidth;
    protected int movieHeight;
    protected IntBuffer moviePixels;
    protected PlayBin2 gplayer;

    public GSMovie(PApplet parent, String filename) {
        this(parent, filename, 30);
    }

    public GSMovie(PApplet parent, String filename, int ifps) {
        block13: {
            super(1, 1, 1);
            this.firstFrame = true;
            this.parent = parent;
            this.gplayer = null;
            GSVideo.init();
            boolean filefound = false;
            try {
                File file;
                try {
                    file = new File(parent.dataPath(filename));
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSMovie Player");
                        this.gplayer.setInputFile(file);
                        filefound = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.gplayer != null) break block13;
                try {
                    file = new File(filename);
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSMovie Player");
                        this.gplayer.setInputFile(file);
                        filefound = true;
                    }
                }
                catch (Exception exception) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.gplayer == null) {
            parent.die("Could not load movie file " + filename, null);
        }
        try {
            this.filename = filename;
            this.fps = ifps;
            parent.registerDispose((Object)this);
            try {
                this.movieEventMethod = parent.getClass().getMethod("movieEvent", GSMovie.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RGBDataAppSink videoSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int w, int h, IntBuffer buffer) {
                    GSMovie.this.invokeEvent(w, h, buffer);
                }
            });
            this.gplayer.setVideoSink((Element)videoSink);
            this.gplayer.getBus().connect(new Bus.EOS(){

                public void endOfStream(GstObject element) {
                    GSMovie.this.eosEvent();
                }
            });
            this.rate = 1.0f;
            this.frameRate(this.fps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.newFrame = false;
    }

    public float duration() {
        float sec = this.gplayer.queryDuration().toSeconds();
        float nanosec = this.gplayer.queryDuration().getNanoSeconds();
        return sec + this.nanoSecToSecFrac(nanosec);
    }

    public void frameRate(int ifps) {
        if (ifps == 0) {
            System.err.println("FPS of zero is invalid");
            return;
        }
        float ffps = ifps;
        float f = ffps / (float)this.fps;
        if (this.play) {
            this.gplayer.pause();
        }
        long t = this.gplayer.queryPosition(TimeUnit.NANOSECONDS);
        this.gplayer.seek((double)(this.rate * f), Format.TIME, 5, SeekType.SET, t, SeekType.NONE, -1L);
        if (this.play) {
            this.gplayer.play();
        }
        this.fps = ifps;
    }

    public void speed(float irate) {
        this.rate = irate;
        this.frameRate(this.fps);
    }

    public float time() {
        float sec = this.gplayer.queryPosition().toSeconds();
        float nanosec = this.gplayer.queryPosition().getNanoSeconds();
        return sec + this.nanoSecToSecFrac(nanosec);
    }

    public long frame() {
        return this.gplayer.queryPosition(Format.DEFAULT);
    }

    public long length() {
        return this.gplayer.queryDuration(Format.DEFAULT);
    }

    public void jump(float where) {
        this.gplayer.seek(ClockTime.fromNanos((long)this.secToNanoLong(where)));
    }

    public boolean available() {
        return this.available;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public void oldFrame() {
        this.newFrame = false;
    }

    public void play() {
        this.play = true;
        this.gplayer.play();
    }

    public void loop() {
        this.play = true;
        this.repeat = true;
        this.gplayer.play();
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.play = false;
        this.gplayer.pause();
    }

    public void stop() {
        this.play = false;
        this.goToBeginning();
        this.gplayer.stop();
    }

    public void read() {
        if (this.firstFrame) {
            super.init(this.movieWidth, this.movieHeight, 1);
            this.loadPixels();
            this.firstFrame = false;
        }
        this.moviePixels.get(this.pixels);
        this.updatePixels();
        this.available = false;
        this.newFrame = true;
    }

    public void goToBeginning() {
        this.gplayer.seek(ClockTime.fromNanos((long)0L));
    }

    public void volume(double v) {
        if (this.play) {
            this.gplayer.setVolume(v);
        }
    }

    public void volume(int v) {
        if (this.play) {
            this.gplayer.setVolume((double)v);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        }
    }

    protected void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.movieWidth = w;
        this.movieHeight = h;
        this.moviePixels = buffer;
        if (this.play && this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke((Object)this.parent, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                e.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    protected float nanoSecToSecFrac(float nanosec) {
        int i = 0;
        while (i < 3) {
            nanosec = (float)((double)nanosec / 1000.0);
            ++i;
        }
        return nanosec;
    }

    protected long secToNanoLong(float sec) {
        Float f = new Float((double)sec * 1.0E9);
        return f.longValue();
    }

    public void dispose() {
        this.stop();
    }

    class FrameReader
    implements Runnable {
        FrameReader() {
        }

        public void run() {
            while (GSMovie.this.play) {
                if (GSMovie.this.available) {
                    GSMovie.this.read();
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

