/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swing;

import com.sun.jna.Platform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.gstreamer.Element;
import org.gstreamer.Pad;
import org.gstreamer.elements.RGBDataSink;
import org.gstreamer.event.NavigationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoComponent
extends JComponent {
    private static final long serialVersionUID = -8916459410626088872L;
    private BufferedImage currentImage = null;
    private final Lock bufferLock = new ReentrantLock();
    private RGBDataSink videosink;
    private Pad videoPad;
    private RenderingHints renderingHints = null;
    private RenderComponent renderComponent = new RenderComponent();
    private static boolean quartzEnabled;
    private static boolean ddscaleEnabled;
    private boolean keepAspect = true;
    private float alpha = 1.0f;
    private Timer resourceTimer;
    private VolatileImage volatileImage;
    private Class graphicsConfigClass = null;
    private boolean frameRendered = false;
    private volatile boolean updatePending = false;
    private final boolean useVolatile;
    private static final Class<?> oglGraphicsConfigClass;
    private static final Map<RenderingHints.Key, Object> openglHints;
    private static final Map<RenderingHints.Key, Object> defaultHints;
    private final MouseInputListener mouseListener = new MouseInputAdapter(){

        private double getX(MouseEvent evt) {
            double scaleX = (double)VideoComponent.this.imgWidth / (double)VideoComponent.this.renderComponent.getWidth();
            return (double)evt.getX() * scaleX;
        }

        private double getY(MouseEvent evt) {
            double scaleY = (double)VideoComponent.this.imgHeight / (double)VideoComponent.this.renderComponent.getHeight();
            return (double)evt.getY() * scaleY;
        }

        private void mouse(String event, MouseEvent evt) {
            NavigationEvent nav = NavigationEvent.createMouseEvent(event, this.getX(evt), this.getY(evt), evt.getButton());
            VideoComponent.this.videoPad.pushEvent(nav);
        }

        public void mousePressed(MouseEvent evt) {
            this.mouse("mouse-button-press", evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.mouse("mouse-button-release", evt);
        }

        public void mouseMoved(MouseEvent evt) {
            this.mouse("mouse-move", evt);
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouse("mouse-move", evt);
        }
    };
    private static final Map<Integer, String> keyMap;
    private final KeyListener keyListener = new KeyAdapter(){

        private String getKey(KeyEvent evt) {
            if (keyMap.containsKey(evt.getKeyCode())) {
                return (String)keyMap.get(evt.getKeyCode());
            }
            return String.valueOf(evt.getKeyChar());
        }

        private void key(String name, KeyEvent evt) {
            VideoComponent.this.videoPad.pushEvent(NavigationEvent.createKeyEvent(name, this.getKey(evt)));
            evt.consume();
        }

        public void keyPressed(KeyEvent evt) {
            this.key("key-press", evt);
        }

        public void keyReleased(KeyEvent evt) {
            this.key("key-release", evt);
        }
    };
    private ActionListener resourceReaper = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            if (!VideoComponent.this.frameRendered) {
                if (VideoComponent.this.volatileImage != null) {
                    VideoComponent.this.volatileImage.flush();
                    VideoComponent.this.volatileImage = null;
                }
                VideoComponent.this.frameRendered = false;
                VideoComponent.this.resourceTimer.stop();
            }
        }
    };
    private int imgWidth = 0;
    private int imgHeight = 0;

    static {
        Class<?> cls;
        quartzEnabled = false;
        ddscaleEnabled = false;
        openglHints = new HashMap<RenderingHints.Key, Object>(){
            private static final long serialVersionUID = 3418333891389270949L;
            {
                this.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                this.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
        };
        defaultHints = new HashMap<RenderingHints.Key, Object>(){
            private static final long serialVersionUID = -3297248815157630205L;
            {
                this.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                this.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        };
        quartzEnabled = Boolean.getBoolean("apple.awt.graphics.UseQuartz");
        try {
            ddscaleEnabled = Boolean.getBoolean("sun.java2d.ddscale") && Boolean.getBoolean("sun.java2d.d3d");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cls = Class.forName("sun.java2d.opengl.OGLGraphicsConfig");
        }
        catch (Exception ex) {
            cls = null;
        }
        oglGraphicsConfigClass = cls;
        keyMap = new HashMap<Integer, String>(){
            private static final long serialVersionUID = 9001444546596702473L;
            {
                this.put(8, "BackSpace");
                this.put(10, "Return");
                this.put(37, "Left");
                this.put(39, "Right");
                this.put(38, "Up");
                this.put(40, "Down");
                this.put(27, "Escape");
                this.put(44, "comma");
                this.put(46, "period");
                this.put(32, "space");
            }
        };
    }

    public VideoComponent() {
        this.videosink = new RGBDataSink("GstVideoComponent", new RGBListener());
        this.videosink.setPassDirectBuffer(true);
        this.videosink.getSinkElement().setMaximumLateness(20L, TimeUnit.MILLISECONDS);
        this.videosink.getSinkElement().setQOSEnabled(true);
        this.useVolatile = !Platform.isMac();
        this.videoPad = this.videosink.getSinkPads().get(0);
        this.resourceTimer = new Timer(250, this.resourceReaper);
        this.setLayout(null);
        this.add(this.renderComponent);
        this.renderComponent.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                VideoComponent.this.setPreferredSize(VideoComponent.this.renderComponent.getPreferredSize());
                VideoComponent.this.scaleVideoOutput();
            }
        });
        this.renderComponent.addMouseListener(this.mouseListener);
        this.renderComponent.addMouseMotionListener(this.mouseListener);
        this.renderComponent.addKeyListener(this.keyListener);
        this.addKeyListener(this.keyListener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent arg0) {
                VideoComponent.this.scaleVideoOutput();
            }
        });
        this.renderComponent.setBounds(this.getBounds());
        this.setOpaque(true);
        this.setBackground(Color.BLACK);
    }

    private void updateRenderingHints(Class<?> gcClass) {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        if (gcClass != null && oglGraphicsConfigClass != null && oglGraphicsConfigClass.isAssignableFrom(gcClass)) {
            hints.putAll(openglHints);
        } else if (quartzEnabled) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else if (ddscaleEnabled) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            hints.putAll(defaultHints);
        }
        this.renderingHints = new RenderingHints(hints);
    }

    private void scaleVideoOutput() {
        RenderComponent child = this.renderComponent;
        Dimension childSize = ((Component)child).getPreferredSize();
        int width = this.getWidth();
        int height = this.getHeight();
        double aspect = this.keepAspect ? (double)childSize.width / (double)childSize.height : 1.0;
        int scaledHeight = (int)((double)width / aspect);
        if (!this.keepAspect) {
            child.setBounds(0, 0, width, height);
        } else if (scaledHeight < height) {
            int y = (height - scaledHeight) / 2;
            child.setBounds(0, y, width, scaledHeight);
        } else {
            int scaledWidth = (int)((double)height * aspect);
            int x = (width - scaledWidth) / 2;
            child.setBounds(x, 0, scaledWidth, height);
        }
    }

    public Element getElement() {
        return this.videosink;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
    }

    @Override
    public boolean isLightweight() {
        return true;
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque() && this.alpha >= 1.0f;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.getBackground());
            if (this.alpha < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
        }
    }

    @Deprecated
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Deprecated
    public float getAlpha() {
        return this.alpha;
    }

    public void setOpacity(float opacity) {
        this.alpha = opacity;
    }

    public float getOpacity() {
        return this.alpha;
    }

    private void renderVolatileImage(BufferedImage bufferedImage) {
        do {
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            if (this.volatileImage == null || this.volatileImage.getWidth() != w || this.volatileImage.getHeight() != h || this.volatileImage.validate(gc) == 2) {
                if (this.volatileImage != null) {
                    this.volatileImage.flush();
                }
                this.volatileImage = gc.createCompatibleVolatileImage(w, h);
                this.volatileImage.setAccelerationPriority(1.0f);
            }
            Graphics2D g = this.volatileImage.createGraphics();
            g.drawImage((Image)bufferedImage, 0, 0, null);
            g.dispose();
        } while (this.volatileImage.contentsLost());
    }

    private void volatileRender(Graphics g, int x, int y, int w, int h) {
        do {
            if (this.updatePending || this.volatileImage == null || this.volatileImage.validate(this.getGraphicsConfiguration()) != 0) {
                this.bufferLock.lock();
                try {
                    this.updatePending = false;
                    this.renderVolatileImage(this.currentImage);
                }
                finally {
                    this.bufferLock.unlock();
                }
            }
            g.drawImage(this.volatileImage, x, y, w, h, null);
        } while (this.volatileImage.contentsLost());
    }

    private void heapRender(Graphics g, int x, int y, int w, int h) {
        this.bufferLock.lock();
        try {
            this.updatePending = false;
            g.drawImage(this.currentImage, x, y, w, h, null);
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    private void render(Graphics g, int x, int y, int w, int h) {
        if (this.useVolatile) {
            this.volatileRender(g, x, y, w, h);
        } else {
            this.heapRender(g, x, y, w, h);
        }
        if (!this.frameRendered) {
            this.frameRendered = true;
            if (!this.resourceTimer.isRunning()) {
                this.resourceTimer.restart();
            }
        }
    }

    private final void update(final int width, final int height) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (width != VideoComponent.this.imgWidth || height != VideoComponent.this.imgHeight) {
                    VideoComponent.this.renderComponent.setPreferredSize(new Dimension(width, height));
                    VideoComponent.this.imgWidth = width;
                    VideoComponent.this.imgHeight = height;
                }
                if (VideoComponent.this.renderComponent.isVisible()) {
                    VideoComponent.this.renderComponent.paintImmediately(0, 0, VideoComponent.this.renderComponent.getWidth(), VideoComponent.this.renderComponent.getHeight());
                }
            }
        });
    }

    private BufferedImage getBufferedImage(int width, int height) {
        if (this.currentImage != null && this.currentImage.getWidth() == width && this.currentImage.getHeight() == height) {
            return this.currentImage;
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
        }
        this.currentImage = new BufferedImage(width, height, 1);
        this.currentImage.setAccelerationPriority(0.0f);
        return this.currentImage;
    }

    private class RGBListener
    implements RGBDataSink.Listener {
        private RGBListener() {
        }

        public void rgbFrame(int width, int height, IntBuffer rgb) {
            if (!VideoComponent.this.bufferLock.tryLock()) {
                return;
            }
            if (VideoComponent.this.updatePending) {
                VideoComponent.this.bufferLock.unlock();
                return;
            }
            try {
                BufferedImage renderImage = VideoComponent.this.getBufferedImage(width, height);
                int[] pixels = ((DataBufferInt)renderImage.getRaster().getDataBuffer()).getData();
                rgb.get(pixels, 0, width * height);
                VideoComponent.this.updatePending = true;
            }
            finally {
                VideoComponent.this.bufferLock.unlock();
            }
            VideoComponent.this.update(VideoComponent.this.currentImage.getWidth(), VideoComponent.this.currentImage.getHeight());
        }
    }

    private class RenderComponent
    extends JComponent {
        private static final long serialVersionUID = -4736605073704494268L;

        private RenderComponent() {
        }

        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g.create();
            if (VideoComponent.this.alpha < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, VideoComponent.this.alpha));
            }
            if (VideoComponent.this.currentImage != null) {
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                if (gc.getClass() != VideoComponent.this.graphicsConfigClass) {
                    VideoComponent.this.graphicsConfigClass = gc.getClass();
                    VideoComponent.this.updateRenderingHints(VideoComponent.this.graphicsConfigClass);
                }
                if (!VideoComponent.this.renderingHints.isEmpty()) {
                    g2d.setRenderingHints(VideoComponent.this.renderingHints);
                }
                VideoComponent.this.render(g2d, 0, 0, width, height);
            } else if (VideoComponent.this.alpha >= 1.0f) {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, width, height);
            }
            g2d.dispose();
        }

        public boolean isOpaque() {
            return VideoComponent.this.isOpaque();
        }

        public boolean isLightweight() {
            return true;
        }
    }
}

