/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.interfaces;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.interfaces.GstInterface;
import org.gstreamer.interfaces.Property;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstPropertyProbeAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyProbe
extends GstInterface {
    private static final GstPropertyProbeAPI gst = GstPropertyProbeAPI.INSTANCE;

    public static final PropertyProbe wrap(Element element) {
        return new PropertyProbe(element);
    }

    private PropertyProbe(Element element) {
        super(element, gst.gst_property_probe_get_type());
    }

    public List<Property> getProperties() {
        return this.propertiesList(gst.gst_property_probe_get_properties(this), true, true);
    }

    public Property getProperty(String name) {
        Pointer ptr = gst.gst_property_probe_get_property(this, name);
        if (ptr == null) {
            return null;
        }
        Property p = new Property(this, ptr, false, false);
        return p;
    }

    public void probeProperty(Property property) {
        if (property != null) {
            gst.gst_property_probe_probe_property(this, property.getSpec());
        }
    }

    public void probeProperty(String name) {
        gst.gst_property_probe_probe_property_name(this, name);
    }

    public boolean needsProbe(Property property) {
        if (property != null) {
            return gst.gst_property_probe_needs_probe(this, property.getSpec());
        }
        return false;
    }

    public boolean needsProbe(String name) {
        return gst.gst_property_probe_needs_probe_name(this, name);
    }

    public Object[] getValues(Property property) {
        if (property != null) {
            return this.valuesArray(gst.gst_property_probe_get_values(this, property.getSpec()));
        }
        return null;
    }

    public Object[] getValues(String name) {
        return this.valuesArray(gst.gst_property_probe_get_values_name(this, name));
    }

    public Object[] probeAndGetValues(Property property) {
        if (property != null) {
            return this.valuesArray(gst.gst_property_probe_probe_and_get_values(this, property.getSpec()));
        }
        return null;
    }

    public Object[] probeAndGetValues(String name) {
        return this.valuesArray(gst.gst_property_probe_probe_and_get_values_name(this, name));
    }

    private List<Property> propertiesList(GlibAPI.GList glist, boolean needRef, boolean ownsHandle) {
        ArrayList<Property> list = new ArrayList<Property>();
        GlibAPI.GList next = glist;
        while (next != null) {
            if (next.data != null) {
                list.add(new Property(this, next.data, needRef, ownsHandle));
            }
            next = next.next();
        }
        return list;
    }

    private Object[] valuesArray(Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        GValueAPI.GValueArray valueArray = null;
        try {
            valueArray = new GValueAPI.GValueArray(ptr);
        }
        catch (NullPointerException ex) {
            return null;
        }
        if (valueArray != null) {
            Object[] objectArray = new Object[valueArray.n_values];
            int i = 0;
            while (i < valueArray.n_values) {
                objectArray[i] = valueArray.getValue(i);
                ++i;
            }
            return objectArray;
        }
        return null;
    }
}

