/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.interfaces;

import com.sun.jna.Pointer;
import org.gstreamer.GObject;
import org.gstreamer.interfaces.Mixer;
import org.gstreamer.lowlevel.GstMixerAPI;
import org.gstreamer.lowlevel.NativeObject;

public class MixerTrack
extends GObject {
    private static final GstMixerAPI gst = GstMixerAPI.INSTANCE;
    private final GstMixerAPI.MixerTrackStruct struct;
    private final Mixer mixer;

    public MixerTrack(NativeObject.Initializer init) {
        super(init);
        throw new IllegalArgumentException("Cannot instantiate this class");
    }

    MixerTrack(Mixer mixer, Pointer ptr, boolean needRef, boolean ownsHandle) {
        super(MixerTrack.initializer(ptr, needRef, ownsHandle));
        this.struct = new GstMixerAPI.MixerTrackStruct(ptr);
        this.mixer = mixer;
    }

    public int getChannelCount() {
        return this.struct.getChannelCount();
    }

    public final boolean hasFlag(int flag) {
        return (this.struct.getFlags() & flag) != 0;
    }

    public boolean isInput() {
        return this.hasFlag(1);
    }

    public boolean isOutput() {
        return this.hasFlag(2);
    }

    public boolean isMuted() {
        return this.hasFlag(4);
    }

    public boolean isRecording() {
        return this.hasFlag(8);
    }

    public void setVolume(int[] volumes) {
        gst.gst_mixer_set_volume(this.mixer, this, volumes);
    }

    public int[] getVolume() {
        int[] volume = new int[this.getChannelCount()];
        gst.gst_mixer_get_volume(this.mixer, this, volume);
        return volume;
    }

    public void setMuted(boolean mute) {
        gst.gst_mixer_set_mute(this.mixer, this, mute);
    }

    public void setRecording(boolean record) {
        gst.gst_mixer_set_record(this.mixer, this, record);
    }

    public static final class Flags {
        public static final int INPUT = 1;
        public static final int OUTPUT = 2;
        public static final int MUTE = 4;
        public static final int RECORD = 8;
        public static final int MASTER = 16;
        public static final int SOFTWARE = 32;
    }
}

