/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.File;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.elements.PlayBin;

public class BusMessages {
    public static void main(String[] args) {
        if ((args = Gst.init("BusMessages", args)).length < 1) {
            System.out.println("Usage: BusMessages <file to play>");
            System.exit(1);
        }
        final PlayBin playbin = new PlayBin("BusMessages");
        playbin.setVideoSink(ElementFactory.make("fakesink", "videosink"));
        playbin.setInputFile(new File(args[0]));
        playbin.getBus().connect(new Bus.EOS(){

            public void endOfStream(GstObject source) {
                System.out.println("Finished playing file");
                Gst.quit();
            }
        });
        playbin.getBus().connect(new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                System.out.println("Error occurred: " + message);
                Gst.quit();
            }
        });
        playbin.getBus().connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                for (String tagName : tagList.getTagNames()) {
                    for (Object tagData : tagList.getValues(tagName)) {
                        System.out.printf("[%s]=%s\n", tagName, tagData);
                    }
                }
            }
        });
        playbin.getBus().connect(new Bus.STATE_CHANGED(){

            public void stateChanged(GstObject source, State old, State current, State pending) {
                if (source == playbin) {
                    System.out.println("Pipeline state changed from " + old + " to " + current);
                }
            }
        });
        playbin.setState(State.PLAYING);
        Gst.main();
        playbin.setState(State.NULL);
        Gst.deinit();
    }
}

