/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gstreamer.Gst;
import org.gstreamer.glib.MainContextExecutorService;
import org.gstreamer.lowlevel.MainLoop;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExecutorServiceTest {
    private static MainLoop loop;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("ExecutorServiceTest", new String[0]);
        loop = new MainLoop();
        loop.startInBackground();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        loop.quit();
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void execute() {
        final TestExec exec = new TestExec();
        exec.execute(new Runnable(){

            public void run() {
                exec.fired();
            }
        });
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }

    @Test
    public void submit() throws Exception {
        final TestExec exec = new TestExec();
        final Integer MAGIC = -559038737;
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                exec.fired();
                return MAGIC;
            }
        };
        Future<Integer> f = exec.exec.submit(callable);
        exec.run();
        Assert.assertTrue((String)"Callable not called", (boolean)exec.hasFired());
        Assert.assertEquals((String)"Wrong value returned from Callable", (Object)MAGIC, (Object)f.get());
    }

    @Test
    public void oneShotTimeout() {
        final TestExec exec = new TestExec();
        exec.exec.schedule(new Runnable(){

            public void run() {
                exec.fired();
            }
        }, 100L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }

    @Test
    public void timeoutWithReturnValue() throws Exception {
        final TestExec exec = new TestExec();
        final Integer MAGIC = -559038737;
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                exec.fired();
                return MAGIC;
            }
        };
        ScheduledFuture<Integer> f = exec.exec.schedule(callable, 100L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
        Assert.assertEquals((String)"Wrong value returned from Callable", (Object)MAGIC, f.get());
    }

    @Test
    public void periodicTimeout() {
        final TestExec exec = new TestExec();
        final AtomicBoolean called = new AtomicBoolean(false);
        exec.exec.scheduleAtFixedRate(new Runnable(){

            public void run() {
                if (called.getAndSet(true)) {
                    exec.fired();
                }
            }
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        exec.run();
        Assert.assertTrue((String)"Runnable not called", (boolean)exec.hasFired());
    }

    private static class TestExec {
        private final CountDownLatch latch = new CountDownLatch(1);
        final MainContextExecutorService exec = new MainContextExecutorService(Gst.getMainContext());
        final AtomicBoolean fired = new AtomicBoolean(false);

        private TestExec() {
        }

        public TestExec run() {
            try {
                this.latch.await(250L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public void execute(Runnable run) {
            this.exec.execute(run);
        }

        public void quit() {
            this.latch.countDown();
        }

        public void fired() {
            this.fired.set(true);
            this.quit();
        }

        public boolean hasFired() {
            return this.fired.get();
        }
    }
}

