/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.gstreamer.Bin;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pad;
import org.gstreamer.PadLinkReturn;
import org.gstreamer.Pipeline;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstPipelineAPI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("BinTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public boolean waitGC(WeakReference<? extends Object> ref) throws InterruptedException {
        System.gc();
        int i = 0;
        while (ref.get() != null && i < 20) {
            Thread.sleep(10L);
            System.gc();
            ++i;
        }
        return ref.get() == null;
    }

    @Test
    public void testGetElements() {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        List<Element> elements = bin.getElements();
        Assert.assertFalse((String)"Bin returned empty list from getElements", (boolean)elements.isEmpty());
        Assert.assertTrue((String)"Element list does not contain e1", (boolean)elements.contains(e1));
        Assert.assertTrue((String)"Element list does not contain e2", (boolean)elements.contains(e2));
    }

    @Test
    public void testGetSinks() throws Exception {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        List<Element> elements = bin.getSinks();
        Assert.assertFalse((String)"Bin returned empty list from getElements", (boolean)elements.isEmpty());
        Assert.assertTrue((String)"Element list does not contain sink", (boolean)elements.contains(e2));
    }

    @Test
    public void testGetSources() throws Exception {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        List<Element> elements = bin.getSources();
        Assert.assertFalse((String)"Bin returned empty list from getElements", (boolean)elements.isEmpty());
        Assert.assertTrue((String)"Element list does not contain source", (boolean)elements.contains(e1));
    }

    @Test
    public void testGetElementByName() throws Exception {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        Assert.assertEquals((String)"source not returned", (Object)e1, (Object)bin.getElementByName("source"));
        Assert.assertEquals((String)"sink not returned", (Object)e2, (Object)bin.getElementByName("sink"));
    }

    @Test
    public void testElementAddedCallback() throws Exception {
        Bin bin = new Bin("test");
        final Element e1 = ElementFactory.make("fakesrc", "source");
        final Element e2 = ElementFactory.make("fakesink", "sink");
        final AtomicInteger added = new AtomicInteger(0);
        bin.connect(new Bin.ELEMENT_ADDED(){

            public void elementAdded(Bin bin, Element elem) {
                if (elem == e1 || elem == e2) {
                    added.incrementAndGet();
                }
            }
        });
        bin.addMany(e1, e2);
        Assert.assertEquals((String)"Callback not called", (long)2L, (long)added.get());
    }

    @Test
    public void testElementRemovedCallback() {
        Bin bin = new Bin("test");
        final Element e1 = ElementFactory.make("fakesrc", "source");
        final Element e2 = ElementFactory.make("fakesink", "sink");
        final AtomicInteger removed = new AtomicInteger(0);
        bin.connect(new Bin.ELEMENT_ADDED(){

            public void elementAdded(Bin bin, Element elem) {
                if (elem == e1 || elem == e2) {
                    removed.incrementAndGet();
                }
            }
        });
        bin.addMany(e1, e2);
        Assert.assertEquals((String)"Callback not called", (long)2L, (long)removed.get());
    }

    @Test
    public void addLinked() {
        Pipeline pipeline = new Pipeline(null);
        Assert.assertNotNull((String)"Could not create pipeline", (Object)pipeline);
        Element src = ElementFactory.make("fakesrc", null);
        Assert.assertNotNull((String)"Could not create fakesrc", (Object)src);
        Element sink = ElementFactory.make("fakesink", null);
        Assert.assertNotNull((String)"Could not create fakesink", (Object)sink);
        Pad srcpad = src.getStaticPad("src");
        Assert.assertNotNull((String)"Could not get src pad", (Object)srcpad);
        Pad sinkpad = sink.getStaticPad("sink");
        Assert.assertNotNull((String)"Could not get sink pad", (Object)sinkpad);
        Assert.assertEquals((String)"Could not link src and sink pads", (Object)PadLinkReturn.OK, (Object)srcpad.link(sinkpad));
        Assert.assertTrue((String)"srcpad not linked", (boolean)srcpad.isLinked());
        Assert.assertTrue((String)"sinkpad not linked", (boolean)sinkpad.isLinked());
        pipeline.add(src);
        Assert.assertFalse((String)"srcpad is still linked after being added to bin", (boolean)srcpad.isLinked());
        Assert.assertFalse((String)"sinkpad is still linked after being added to bin", (boolean)sinkpad.isLinked());
        Assert.assertEquals((String)"Should not be able to link pads in different hierarchy", (Object)PadLinkReturn.WRONG_HIERARCHY, (Object)srcpad.link(sinkpad));
        pipeline.add(sink);
        Assert.assertEquals((String)"Could not link src and sink pads when in same bin", (Object)PadLinkReturn.OK, (Object)srcpad.link(sinkpad));
        Assert.assertTrue((String)"srcpad not linked", (boolean)srcpad.isLinked());
        Assert.assertTrue((String)"sinkpad not linked", (boolean)sinkpad.isLinked());
        pipeline.dispose();
        src.dispose();
        sink.dispose();
        srcpad.dispose();
        sinkpad.dispose();
    }

    @Test
    public void addSelf() {
        Bin bin = new Bin("");
        bin.dispose();
    }

    public void iterateSorted() {
        Pipeline pipeline = GstPipelineAPI.INSTANCE.gst_pipeline_new(null);
        Assert.assertNotNull((String)"Failed to create Pipeline", (Object)pipeline);
        Bin bin = GstBinAPI.INSTANCE.gst_bin_new(null);
        Assert.assertNotNull((String)"Failed to create bin", (Object)bin);
        Element src = ElementFactory.make("fakesrc", null);
        Assert.assertNotNull((String)"Failed to create fakesrc", (Object)src);
        Element tee = ElementFactory.make("tee", null);
        Assert.assertNotNull((String)"Failed to create tee", (Object)tee);
        Element sink1 = ElementFactory.make("fakesink", null);
        Assert.assertNotNull((String)"Failed to create fakesink", (Object)sink1);
        bin.addMany(src, tee, sink1);
        Assert.assertTrue((String)"Could not link fakesrc to tee", (boolean)src.link(tee));
        Assert.assertTrue((String)"Could not link tee to fakesink", (boolean)tee.link(sink1));
        Element identity = ElementFactory.make("identity", null);
        Assert.assertNotNull((String)"Failed to create identity", (Object)identity);
        Element sink2 = ElementFactory.make("fakesink", null);
        Assert.assertNotNull((String)"Failed to create fakesink", (Object)sink2);
        pipeline.addMany(bin, identity, sink2);
        Assert.assertTrue((String)"Could not link tee to identity", (boolean)tee.link(identity));
        Assert.assertTrue((String)"Could not link identity to second fakesink", (boolean)identity.link(sink2));
        Iterator<Element> it = pipeline.getElementsSorted().iterator();
        Assert.assertEquals((String)"First sorted element should be sink2", (Object)sink2, (Object)it.next());
        Assert.assertEquals((String)"Second sorted element should be identity", (Object)identity, (Object)it.next());
        Assert.assertEquals((String)"Third sorted element should be bin", (Object)bin, (Object)it.next());
        pipeline.dispose();
    }
}

