/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.io.File;
import java.nio.ByteBuffer;
import org.gstreamer.Buffer;
import org.gstreamer.elements.RGBDataFileSink;
import processing.core.PApplet;

public class GSMovieMaker {
    private PApplet parent;
    private boolean recording;
    private RGBDataFileSink recorder;
    private int width;
    private int height;
    private int nConsecutiveFilledQueue;
    public static final int THEORA = 0;
    public static final int XVID = 1;
    public static final int X264 = 2;
    public static final int WORST = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int BEST = 4;

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename) {
        this.init(parent, requestWidth, requestHeight, filename, 0, 2, 30);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, int codecType, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, codecType, 2, ifps);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, int codecType, int codecQuality, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, codecType, codecQuality, ifps);
    }

    public void addFrame(int[] pixels) {
        if (this.recording && pixels.length == this.width * this.height) {
            Buffer srcBuffer = new Buffer(this.width * this.height * 4);
            ByteBuffer tmpBuffer = srcBuffer.getByteBuffer();
            tmpBuffer.clear();
            tmpBuffer.asIntBuffer().put(pixels);
            int n = this.recorder.getNumQueuedFrames();
            if (n > 0) {
                ++this.nConsecutiveFilledQueue;
                if (3 < this.nConsecutiveFilledQueue) {
                    System.err.println("Warning: GSMovieMaker is filling up with unprocessed frames. Try using a lower framerate (both for drawing and saving), or a smaller video resolution.");
                }
            } else {
                this.nConsecutiveFilledQueue = 0;
            }
            this.recorder.pushRGBFrame(srcBuffer);
        }
    }

    public void start() {
        this.recorder.start();
        this.recording = true;
    }

    public void finish() {
        this.recording = false;
        this.recorder.stop();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void dispose() {
    }

    protected void init(PApplet parent, int requestWidth, int requestHeight, String filename, int codecType, int codecQuality, int ifps) {
        this.parent = parent;
        this.width = requestWidth;
        this.height = requestHeight;
        GSVideo.init();
        parent.registerDispose((Object)this);
        String[] propNames = null;
        Object[] propValues = null;
        String encoder = "";
        String muxer = "";
        if (codecType == 0) {
            encoder = "theoraenc";
            muxer = "oggmux";
            propNames = new String[]{"quality"};
            propValues = new Object[1];
            Integer q = 31;
            if (codecQuality == 0) {
                q = 0;
            } else if (codecQuality == 1) {
                q = 15;
            } else if (codecQuality == 2) {
                q = 31;
            } else if (codecQuality == 3) {
                q = 47;
            } else if (codecQuality == 4) {
                q = 63;
            }
            propValues[0] = q;
        } else if (codecType == 1) {
            encoder = "xvidenc";
            muxer = "avimux";
        } else if (codecType == 2) {
            encoder = "x264enc";
            muxer = "avimux";
        } else {
            parent.die("Unrecognized video format", null);
        }
        File file = new File(parent.savePath(filename));
        this.recorder = new RGBDataFileSink("MovieMaker", this.width, this.height, ifps, encoder, propNames, propValues, muxer, file);
        this.recorder.setQueueSize(100);
        this.recording = false;
        this.nConsecutiveFilledQueue = 0;
    }
}

