/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.elements.RGBDataSink;
import org.gstreamer.interfaces.Property;
import org.gstreamer.interfaces.PropertyProbe;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSCapture
extends PImage
implements PConstants {
    protected Method captureEventMethod;
    protected boolean available;
    protected boolean newFrame;
    protected boolean firstFrame = true;
    protected int captureWidth;
    protected int captureHeight;
    protected IntBuffer capturePixels;
    protected Pipeline gpipe;

    public GSCapture(PApplet parent, int requestWidth, int requestHeight) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], 25);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], frameRate);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String cameraName) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        if (cameraName != null && !cameraName.equals("")) {
            this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, 25);
        } else {
            this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], 25);
        }
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String sourceName, String cameraName) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        if (cameraName != null && !cameraName.equals("")) {
            this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, 25, false);
        } else {
            this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], new String[0], new String[0], 25, false);
        }
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String cameraName, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        if (cameraName != null && !cameraName.equals("")) {
            this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, frameRate);
        } else {
            this.initOS(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], frameRate);
        }
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String sourceName, String cameraName, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        if (cameraName != null && !cameraName.equals("")) {
            this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, frameRate, false);
        } else {
            this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], new String[0], new String[0], frameRate, false);
        }
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.initOS(requestWidth, requestHeight, intPropNames, intPropValues, strPropNames, strPropValues, frameRate);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String sourceName, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.init(requestWidth, requestHeight, sourceName, intPropNames, intPropValues, strPropNames, strPropValues, frameRate, false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String sourceName, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, int frameRate, boolean addDecoder) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.init(requestWidth, requestHeight, sourceName, intPropNames, intPropValues, strPropNames, strPropValues, frameRate, addDecoder);
    }

    public void read() {
        if (this.firstFrame) {
            this.loadPixels();
            this.firstFrame = false;
        }
        this.capturePixels.get(this.pixels);
        this.updatePixels();
        this.available = false;
        this.newFrame = true;
    }

    public static String[] list() {
        if (PApplet.platform == 3) {
            return GSCapture.list("v4l2src");
        }
        if (PApplet.platform == 1) {
            return GSCapture.list("ksvideosrc");
        }
        if (PApplet.platform == 2) {
            return GSCapture.list("osxvideosrc");
        }
        return null;
    }

    public static String[] list(String sourceName) {
        Object[] values;
        Property property;
        GSVideo.init();
        String[] deviceListing = new String[]{};
        Element videoSource = ElementFactory.make((String)sourceName, (String)"Source");
        PropertyProbe probe = PropertyProbe.wrap((Element)videoSource);
        if (probe != null && (property = probe.getProperty(GSCapture.devicePropertyName())) != null && (values = probe.getValues(property)) != null) {
            deviceListing = new String[values.length];
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof String) {
                    deviceListing[i] = (String)values[i];
                }
                ++i;
            }
        }
        return deviceListing;
    }

    public void frameRate(int iframeRate) {
    }

    public boolean available() {
        return this.available;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public void oldFrame() {
        this.newFrame = false;
    }

    public void resume() {
        this.gpipe.setState(State.PLAYING);
    }

    public void stop() {
        this.gpipe.setState(State.PAUSED);
    }

    protected void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.captureWidth = w;
        this.captureHeight = h;
        this.capturePixels = buffer;
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke((Object)this.parent, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling captureEvent() for videotestsrc");
                e.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    public void dispose() {
    }

    protected void initOS(int requestWidth, int requestHeight, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, int frameRate) {
        if (PApplet.platform == 3) {
            this.init(requestWidth, requestHeight, "v4l2src", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, false);
        } else if (PApplet.platform == 1) {
            this.init(requestWidth, requestHeight, "ksvideosrc", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, false);
        } else if (PApplet.platform == 2) {
            this.init(requestWidth, requestHeight, "osxvideosrc", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, false);
        } else {
            this.parent.die("Error: unrecognized platform.", null);
        }
    }

    protected void init(int requestWidth, int requestHeight, String sourceName, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, int frameRate, boolean addDecoder) {
        this.gpipe = null;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        try {
            this.captureEventMethod = this.parent.getClass().getMethod("captureEvent", GSCapture.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gpipe = new Pipeline("GSCapturePipeline");
        Element videoSource = ElementFactory.make((String)sourceName, (String)"Source");
        if (intPropNames.length != intPropValues.length) {
            this.parent.die("Error: number of integer property names is different from number of values.", null);
        }
        int i = 0;
        while (i < intPropNames.length) {
            videoSource.set(intPropNames[i], (Object)intPropValues[i]);
            ++i;
        }
        if (strPropNames.length != strPropValues.length) {
            this.parent.die("Error: number of string property names is different from number of values.", null);
        }
        i = 0;
        while (i < strPropNames.length) {
            videoSource.set(strPropNames[i], (Object)strPropValues[i]);
            ++i;
        }
        Element conv = ElementFactory.make((String)"ffmpegcolorspace", (String)"ColorConverter");
        Element videofilter = ElementFactory.make((String)"capsfilter", (String)"ColorFilter");
        videofilter.setCaps(new Caps("video/x-raw-rgb, width=" + requestWidth + ", height=" + requestHeight + ", bpp=32, depth=24"));
        RGBDataSink videoSink = new RGBDataSink("rgb", new RGBDataSink.Listener(){

            public void rgbFrame(int w, int h, IntBuffer buffer) {
                GSCapture.this.invokeEvent(w, h, buffer);
            }
        });
        if (addDecoder) {
            Element decoder = ElementFactory.make((String)"decodebin", (String)"Decoder");
            this.gpipe.addMany(new Element[]{videoSource, decoder, conv, videofilter, videoSink});
            Element.linkMany((Element[])new Element[]{videoSource, decoder, conv, videofilter, videoSink});
        } else {
            this.gpipe.addMany(new Element[]{videoSource, conv, videofilter, videoSink});
            Element.linkMany((Element[])new Element[]{videoSource, conv, videofilter, videoSink});
        }
        this.gpipe.setState(State.PLAYING);
        this.newFrame = false;
    }

    protected static String devicePropertyName() {
        if (PApplet.platform == 3) {
            return "device";
        }
        if (PApplet.platform == 1) {
            return "device-name";
        }
        if (PApplet.platform == 2) {
            return "device-name";
        }
        return "";
    }
}

