/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.gstreamer.Gst;
import org.gstreamer.lowlevel.GMainContext;
import org.gstreamer.lowlevel.GSource;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.RefCountedObject;

public class MainLoop
extends RefCountedObject {
    private static final List<Runnable> bgTasks = new LinkedList<Runnable>();
    private static final GlibAPI.GSourceFunc bgCallback = new GlibAPI.GSourceFunc(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callback(Pointer source) {
            ArrayList tasks = new ArrayList();
            List list = bgTasks;
            synchronized (list) {
                tasks.addAll(bgTasks);
                bgTasks.clear();
            }
            for (Runnable r : tasks) {
                r.run();
            }
            GlibAPI.glib.g_source_unref(source);
            return false;
        }
    };
    private Thread bgThread;

    public MainLoop() {
        super(MainLoop.initializer(GlibAPI.glib.g_main_loop_new(Gst.getMainContext(), false)));
    }

    public MainLoop(NativeObject.Initializer init) {
        super(init);
    }

    public void quit() {
        this.invokeLater(new Runnable(){

            public void run() {
                GlibAPI.glib.g_main_loop_quit(MainLoop.this);
            }
        });
    }

    public void run() {
        GlibAPI.glib.g_main_loop_run(this);
    }

    public boolean isRunning() {
        return GlibAPI.glib.g_main_loop_is_running(this);
    }

    public GMainContext getMainContext() {
        return GlibAPI.glib.g_main_loop_get_context(this);
    }

    public void startInBackground() {
        this.bgThread = new Thread(new Runnable(){

            public void run() {
                MainLoop.this.run();
            }
        });
        this.bgThread.setDaemon(true);
        this.bgThread.setName("gmainloop");
        this.bgThread.start();
    }

    public void invokeAndWait(Runnable r) {
        FutureTask<Object> task = new FutureTask<Object>(r, null);
        this.invokeLater(task);
        try {
            task.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        List<Runnable> list = bgTasks;
        synchronized (list) {
            boolean empty = bgTasks.isEmpty();
            bgTasks.add(r);
            if (empty) {
                GSource source = GlibAPI.glib.g_idle_source_new();
                GlibAPI.glib.g_source_set_callback(source, bgCallback, source, null);
                source.attach(Gst.getMainContext());
                source.disown();
            }
        }
    }

    protected void ref() {
        GlibAPI.glib.g_main_loop_ref(this);
    }

    protected void unref() {
        GlibAPI.glib.g_main_loop_unref(this);
    }

    protected void disposeNativeHandle(Pointer ptr) {
        GlibAPI.glib.g_main_loop_unref(ptr);
    }
}

