/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.interfaces;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.awt.Component;
import org.eclipse.swt.widgets.Composite;
import org.gstreamer.Element;
import org.gstreamer.interfaces.GstInterface;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstXOverlayAPI;

public class XOverlay
extends GstInterface {
    private static final GstXOverlayAPI gst = GstNative.load("gstinterfaces", GstXOverlayAPI.class);

    public static final XOverlay wrap(Element element) {
        return new XOverlay(element);
    }

    private XOverlay(Element element) {
        super(element, gst.gst_x_overlay_get_type());
    }

    public void setWindowID(Component window) {
        if (window == null) {
            gst.gst_x_overlay_set_xwindow_id(this, new NativeLong(0L));
            return;
        }
        if (window.isLightweight()) {
            throw new IllegalArgumentException("Component must be be a native window");
        }
        if (Platform.isWindows()) {
            gst.gst_x_overlay_set_xwindow_id(this, Native.getComponentPointer((Component)window));
        } else {
            gst.gst_x_overlay_set_xwindow_id(this, new NativeLong(Native.getComponentID((Component)window)));
        }
    }

    public void setWindowID(Composite comp) {
        if (!Platform.isLinux() || comp == null || (comp.getStyle() | 0x1000000) == 0) {
            gst.gst_x_overlay_set_xwindow_id(this, new NativeLong(0L));
            return;
        }
        gst.gst_x_overlay_set_xwindow_id(this, new NativeLong((long)comp.embeddedHandle));
    }

    public void expose() {
        gst.gst_x_overlay_expose(this);
    }
}

