/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pad;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.elements.PlayBin;

public class TagFinder {
    private static final String progname = "TagFinder";

    public static void main(String[] args) {
        final CountDownLatch done = new CountDownLatch(1);
        if ((args = Gst.init(progname, args)).length < 0) {
            System.out.println("Usage: TagFinder <filename>");
            System.exit(1);
        }
        final PlayBin pipe = new PlayBin(progname);
        pipe.setInputFile(new File(args[0]));
        Element audio = ElementFactory.make("fakesink", "audio-sink");
        Element video = ElementFactory.make("fakesink", "video-sink");
        pipe.setAudioSink(audio);
        pipe.setVideoSink(video);
        pipe.getBus().connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                for (String tag : tagList.getTagNames()) {
                    System.out.println("Found tag " + tag + " = " + tagList.getValue(tag, 0));
                }
            }
        });
        pipe.getBus().connect(new Bus.ASYNC_DONE(){

            public void asyncDone(GstObject source) {
                pipe.setState(State.NULL);
                done.countDown();
            }
        });
        audio.set("signal-handoffs", true);
        video.set("signal-handoffs", true);
        Element.HANDOFF handoff = new Element.HANDOFF(){

            public void handoff(Element element, Buffer buffer, Pad pad) {
                pipe.setState(State.NULL);
                done.countDown();
            }
        };
        audio.connect(handoff);
        video.connect(handoff);
        pipe.setState(State.PAUSED);
        try {
            done.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        pipe.setState(State.NULL);
    }
}

