/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.io.File;
import java.net.URI;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Pipeline;
import org.gstreamer.lowlevel.NativeObject;

public class PlayBin2
extends Pipeline {
    public PlayBin2(String name) {
        this(PlayBin2.makeRawElement("playbin2", name));
    }

    public PlayBin2(String name, URI uri) {
        this(name);
        this.setURI(uri);
    }

    public PlayBin2(NativeObject.Initializer init) {
        super(init);
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = String.valueOf(p) + "/";
        }
        return p;
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setURI(URI uri) {
        this.set("uri", uri);
    }

    public void setAudioSink(Element element) {
        this.setElement("audio-sink", element);
    }

    public void setVideoSink(Element element) {
        this.setElement("video-sink", element);
    }

    public void setVisualization(Element element) {
        this.setElement("vis-plugin", element);
    }

    private void setElement(String key, Element element) {
        if (element == null) {
            element = ElementFactory.make("fakesink", "fake-" + key);
        }
        this.set(key, element);
    }

    public void setVolumePercent(int percent) {
        this.setVolume(Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0);
    }

    public int getVolumePercent() {
        return (int)(this.getVolume() * 100.0 + 0.5);
    }

    public void setVolume(double volume) {
        this.set("volume", volume);
    }

    public double getVolume() {
        return ((Number)this.get("volume")).doubleValue();
    }
}

