/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.BusSyncReply;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Message;
import org.gstreamer.MessageType;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.event.BusSyncHandler;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstBusAPI;
import org.gstreamer.lowlevel.GstMessageAPI;
import org.gstreamer.lowlevel.GstMiniObjectAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bus
extends GstObject {
    static final Logger log = Logger.getLogger(Bus.class.getName());
    static final Level LOG_DEBUG = Level.FINE;
    private static final API gst = GstNative.load(API.class);
    private BusSyncHandler syncHandler = new BusSyncHandler(){

        public BusSyncReply syncMessage(Message msg) {
            return BusSyncReply.PASS;
        }
    };
    private static GstAPI.GstCallback syncCallback = new GstAPI.GstCallback(){

        public int callback(final Bus bus, final Message msg, Pointer data) {
            BusSyncReply reply = bus.syncHandler.syncMessage(msg);
            if (reply != BusSyncReply.DROP) {
                Gst.getExecutor().execute(new Runnable(){

                    public void run() {
                        bus.dispatchMessage(msg);
                    }
                });
            }
            gst.gst_mini_object_unref(msg);
            return BusSyncReply.DROP.intValue();
        }
    };
    private Map<Class<?>, Map<Object, MessageProxy>> signalListeners;
    private List<MessageProxy> messageProxies = new CopyOnWriteArrayList<MessageProxy>();

    public Bus(NativeObject.Initializer init) {
        super(init);
        gst.gst_bus_set_sync_handler(this, null, null);
        gst.gst_bus_set_sync_handler(this, syncCallback, null);
    }

    public void setFlushing(boolean flushing) {
        gst.gst_bus_set_flushing(this, flushing ? 1 : 0);
    }

    public void connect(final EOS listener) {
        this.connect((Class)EOS.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.endOfStream(msg.getSource());
                return true;
            }
        });
    }

    public void disconnect(EOS listener) {
        super.disconnect(EOS.class, listener);
    }

    public void connect(final ERROR listener) {
        this.connect((Class)ERROR.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                gst.gst_message_parse_error(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.errorMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.glib.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(ERROR listener) {
        super.disconnect(ERROR.class, listener);
    }

    public void connect(final WARNING listener) {
        this.connect((Class)WARNING.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                gst.gst_message_parse_warning(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.warningMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.glib.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(WARNING listener) {
        super.disconnect(WARNING.class, listener);
    }

    public void connect(final INFO listener) {
        this.connect((Class)INFO.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference err = new PointerByReference();
                gst.gst_message_parse_info(msg, err, null);
                GstAPI.GErrorStruct error = new GstAPI.GErrorStruct(err.getValue());
                listener.infoMessage(msg.getSource(), error.getCode(), error.getMessage());
                GlibAPI.glib.g_error_free(err.getValue());
                return true;
            }
        });
    }

    public void disconnect(INFO listener) {
        super.disconnect(INFO.class, listener);
    }

    public void connect(final STATE_CHANGED listener) {
        this.connect((Class)STATE_CHANGED.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                State[] o = new State[1];
                State[] n = new State[1];
                State[] p = new State[1];
                gst.gst_message_parse_state_changed(msg, o, n, p);
                listener.stateChanged(msg.getSource(), o[0], n[0], p[0]);
                return true;
            }
        });
    }

    public void disconnect(STATE_CHANGED listener) {
        super.disconnect(STATE_CHANGED.class, listener);
    }

    public void connect(final TAG listener) {
        this.connect((Class)TAG.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                PointerByReference list = new PointerByReference();
                gst.gst_message_parse_tag(msg, list);
                TagList tl = new TagList(Bus.access$3(list.getValue()));
                listener.tagsFound(msg.getSource(), tl);
                return true;
            }
        });
    }

    public void disconnect(TAG listener) {
        super.disconnect(TAG.class, listener);
    }

    public void connect(final BUFFERING listener) {
        this.connect((Class)BUFFERING.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                int[] percent = new int[1];
                gst.gst_message_parse_buffering(msg, percent);
                listener.bufferingData(msg.getSource(), percent[0]);
                return true;
            }
        });
    }

    public void disconnect(BUFFERING listener) {
        super.disconnect(BUFFERING.class, listener);
    }

    public void connect(final DURATION listener) {
        this.connect((Class)DURATION.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                System.out.println("duration update");
                Format[] format = new Format[1];
                long[] duration = new long[1];
                gst.gst_message_parse_duration(msg, format, duration);
                listener.durationChanged(msg.getSource(), format[0], duration[0]);
                return true;
            }
        });
    }

    public void disconnect(DURATION listener) {
        super.disconnect(DURATION.class, listener);
    }

    public void connect(final SEGMENT_START listener) {
        this.connect((Class)SEGMENT_START.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                Format[] format = new Format[1];
                long[] position = new long[1];
                gst.gst_message_parse_segment_start(msg, format, position);
                listener.segmentStart(msg.getSource(), format[0], position[0]);
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_START listener) {
        super.disconnect(SEGMENT_START.class, listener);
    }

    public void connect(final SEGMENT_DONE listener) {
        this.connect((Class)SEGMENT_DONE.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                Format[] format = new Format[1];
                long[] position = new long[1];
                gst.gst_message_parse_segment_done(msg, format, position);
                listener.segmentDone(msg.getSource(), format[0], position[0]);
                return true;
            }
        });
    }

    public void disconnect(SEGMENT_DONE listener) {
        super.disconnect(SEGMENT_DONE.class, listener);
    }

    public void connect(final ASYNC_DONE listener) {
        this.connect((Class)ASYNC_DONE.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.asyncDone(msg.getSource());
                return true;
            }
        });
    }

    public void disconnect(ASYNC_DONE listener) {
        super.disconnect(ASYNC_DONE.class, listener);
    }

    public void connect(final MESSAGE listener) {
        this.connect((Class)MESSAGE.class, (Object)listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.busMessage(bus, msg);
                return true;
            }
        });
    }

    public void connect(String signal, final MESSAGE listener) {
        if (signal.contains("::")) {
            signal = signal.substring(signal.lastIndexOf("::") + 2);
        }
        this.connect(signal, MESSAGE.class, listener, new GstBusAPI.BusCallback(){

            public boolean callback(Bus bus, Message msg, Pointer user_data) {
                listener.busMessage(bus, msg);
                return true;
            }
        });
    }

    public void disconnect(MESSAGE listener) {
        super.disconnect(MESSAGE.class, listener);
    }

    public boolean post(Message message) {
        return gst.gst_bus_post(this, message);
    }

    public void setSyncHandler(BusSyncHandler handler) {
        this.syncHandler = handler;
    }

    private <T> void connect(Class<T> listenerClass, T listener, GstBusAPI.BusCallback callback) {
        String signal = listenerClass.getSimpleName().toLowerCase().replaceAll("_", "-");
        this.connect(signal, listenerClass, listener, callback);
    }

    @Override
    public synchronized <T> void connect(String signal, Class<T> listenerClass, T listener, Callback callback) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.connect(signal, listenerClass, listener, callback);
            return;
        }
        MessageType type = MessageType.forName(signal);
        if (type == MessageType.UNKNOWN && "message".equals(signal)) {
            type = MessageType.ANY;
        }
        if (type == MessageType.UNKNOWN) {
            throw new IllegalArgumentException("Illegal signal: " + signal);
        }
        Map<Class<?>, Map<Object, MessageProxy>> signals = this.getListenerMap();
        Map<Object, MessageProxy> m = signals.get(type);
        if (m == null) {
            m = new HashMap<Object, MessageProxy>();
            signals.put(listenerClass, m);
        }
        MessageProxy proxy = new MessageProxy(type, (GstBusAPI.BusCallback)callback);
        m.put(listener, proxy);
        this.messageProxies.add(proxy);
    }

    @Override
    public synchronized <T> void disconnect(Class<T> listenerClass, T listener) {
        if (listenerClass.getEnclosingClass() != Bus.class) {
            super.disconnect(listenerClass, listener);
            return;
        }
        Map<Class<?>, Map<Object, MessageProxy>> signals = this.getListenerMap();
        Map<Object, MessageProxy> m = signals.get(listenerClass);
        if (m != null) {
            MessageProxy proxy = m.remove(listener);
            if (proxy != null) {
                this.messageProxies.remove(proxy);
            }
            if (m.isEmpty()) {
                signals.remove(listenerClass);
            }
        }
    }

    private void dispatchMessage(Message msg) {
        for (MessageProxy listener : this.messageProxies) {
            listener.busMessage(this, msg);
        }
    }

    private final Map<Class<?>, Map<Object, MessageProxy>> getListenerMap() {
        if (this.signalListeners == null) {
            this.signalListeners = new ConcurrentHashMap();
        }
        return this.signalListeners;
    }

    static /* synthetic */ NativeObject.Initializer access$3(Pointer pointer) {
        return NativeObject.initializer(pointer);
    }

    private static interface API
    extends GstBusAPI,
    GstMessageAPI,
    GstMiniObjectAPI {
    }

    public static interface ASYNC_DONE {
        public void asyncDone(GstObject var1);
    }

    public static interface BUFFERING {
        public void bufferingData(GstObject var1, int var2);
    }

    public static interface DURATION {
        public void durationChanged(GstObject var1, Format var2, long var3);
    }

    public static interface EOS {
        public void endOfStream(GstObject var1);
    }

    public static interface ERROR {
        public void errorMessage(GstObject var1, int var2, String var3);
    }

    public static interface INFO {
        public void infoMessage(GstObject var1, int var2, String var3);
    }

    public static interface MESSAGE {
        public void busMessage(Bus var1, Message var2);
    }

    private static class MessageProxy
    implements MESSAGE {
        private final MessageType type;
        private final GstBusAPI.BusCallback callback;

        public MessageProxy(MessageType type, GstBusAPI.BusCallback callback) {
            this.type = type;
            this.callback = callback;
        }

        public void busMessage(Bus bus, Message msg) {
            if ((this.type.intValue() & msg.getType().intValue()) != 0) {
                this.callback.callback(bus, msg, null);
            }
        }
    }

    public static interface SEGMENT_DONE {
        public void segmentDone(GstObject var1, Format var2, long var3);
    }

    public static interface SEGMENT_START {
        public void segmentStart(GstObject var1, Format var2, long var3);
    }

    public static interface STATE_CHANGED {
        public void stateChanged(GstObject var1, State var2, State var3, State var4);
    }

    public static interface TAG {
        public void tagsFound(GstObject var1, TagList var2);
    }

    public static interface WARNING {
        public void warningMessage(GstObject var1, int var2, String var3);
    }
}

