/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.GstIterator;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bin
extends Element {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);

    public Bin(NativeObject.Initializer init) {
        super(init);
    }

    public Bin() {
        this(Bin.initializer(gst.ptr_gst_bin_new(null)));
    }

    public Bin(String name) {
        this(Bin.initializer(gst.ptr_gst_bin_new(name)));
    }

    public boolean add(Element element) {
        return gst.gst_bin_add(this, element);
    }

    public void addMany(Element ... elements) {
        gst.gst_bin_add_many(this, elements);
    }

    public boolean remove(Element element) {
        return gst.gst_bin_remove(this, element);
    }

    public void removeMany(Element ... elements) {
        gst.gst_bin_remove_many(this, elements);
    }

    private List<Element> elementList(Pointer iter) {
        return new GstIterator<Element>(iter, Element.class).asList();
    }

    public List<Element> getElements() {
        return this.elementList(gst.gst_bin_iterate_elements(this));
    }

    public List<Element> getElementsSorted() {
        return this.elementList(gst.gst_bin_iterate_sorted(this));
    }

    public List<Element> getElementsRecursive() {
        return this.elementList(gst.gst_bin_iterate_recurse(this));
    }

    public List<Element> getSinks() {
        return this.elementList(gst.gst_bin_iterate_sinks(this));
    }

    public List<Element> getSources() {
        return this.elementList(gst.gst_bin_iterate_sources(this));
    }

    public Element getElementByName(String name) {
        return gst.gst_bin_get_by_name(this, name);
    }

    public Element getElementByNameRecurseUp(String name) {
        return gst.gst_bin_get_by_name_recurse_up(this, name);
    }

    public <T extends Element> T getElementByInterface(Class<T> iface) {
        return (T)((Element)iface.cast(gst.gst_bin_get_by_interface(this, GstTypes.typeFor(iface))));
    }

    public void connect(final ELEMENT_ADDED listener) {
        this.connect(ELEMENT_ADDED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Element elem, Pointer user_data) {
                listener.elementAdded(bin, elem);
            }
        });
    }

    public void connect(final ELEMENT_REMOVED listener) {
        this.connect(ELEMENT_REMOVED.class, listener, new GstAPI.GstCallback(){

            public void callback(Bin bin, Element elem, Pointer user_data) {
                listener.elementRemoved(bin, elem);
            }
        });
    }

    public void disconnect(ELEMENT_ADDED listener) {
        this.disconnect(ELEMENT_ADDED.class, listener);
    }

    public void disconnect(ELEMENT_REMOVED listener) {
        this.disconnect(ELEMENT_REMOVED.class, listener);
    }

    public static interface ELEMENT_ADDED {
        public void elementAdded(Bin var1, Element var2);
    }

    public static interface ELEMENT_REMOVED {
        public void elementRemoved(Bin var1, Element var2);
    }
}

