
import codeanticode.gsvideo.*;
import java.awt.Rectangle;

/**	NyARToolkit for proce55ing/0.3.0
	(c)2008-2010 nyatla
	airmail(at)ebony.plala.or.jp

        Modified for TMA requirements by Rein Velt (rein@mechanicape.com)
*/
 

import jp.nyatla.nyar4psg.*;
import processing.opengl.*;
import javax.media.opengl.*;

GSCapture cam;
NyARBoard nya;
NyARBoard tma;
PFont font;
PImage logo;
PImage help;
int fail;




void setup() {
  fail=0;
  //size(640,480,OPENGL);
   size(640,480,OPENGL);
  colorMode(RGB, 100);
  font=createFont("FFScala", 32);
  cam=new GSCapture(this,width,height);
  nya=new NyARBoard(this,width,height,"camera_para.dat","patt.hiro",80);
  logo=loadImage("tmalogo.png");
  help=loadImage("help.png");
  print(nya.VERSION);
  nya.gsThreshold=110;//(0<n<255) default=110
  nya.cfThreshold=0.4;//(0.0<n<1.0) default=0.4
  nya.lostDelay=10;//(0<n) default=10
  
}




void drawMarkerPos(int[][] points)
{
  textFont(font,10.0);
  stroke(100,0,0);
  fill(100,0,0);
  for(int i=0;i<4;i++){
    ellipse(nya.pos2d[i][0], nya.pos2d[i][1],5,5);
  }
  fill(0,0,0);
  for(int i=0;i<4;i++){
    text("("+nya.pos2d[i][0]+","+nya.pos2d[i][1]+")",nya.pos2d[i][0],nya.pos2d[i][1]);
  }
}




String angle2text(float a)
{
  int i=(int)degrees(a);
  i=(i>0?i:i+360);
  return (i<100?"  ":i<10?" ":"")+Integer.toString(i);
}


String trans2text(float i)
{
  return (i<100?"  ":i<10?" ":"")+Integer.toString((int)i);
}



void drawAR() {
  //background(255);

  if (cam.available() !=true) {
    return;
  }
  cam.read();

  hint(DISABLE_DEPTH_TEST);
  image(cam,0,0);

  hint(ENABLE_DEPTH_TEST);
  image(logo,0,0);
  fill(255,255,255);
  stroke(255,255,255);
  text("TMA augmented reality framework v0.11",10,470);
  fill(255,0,0);
    text("http://mechanicape.com",500,470);
  if(nya.detect(cam)){
    if ((nya.confidence*100)>50)
    {
      fail=0;
    }
    hint(DISABLE_DEPTH_TEST);
    //一致度を書く
    textFont(font,25.0);
    fill((int)((1.0-nya.confidence)*100),(int)(nya.confidence*100),0);
    text((int)(nya.confidence*100)+"%",width-60,height-20);
    //マーカの角度、水平位置等
    pushMatrix();
    textFont(font,10.0);
    fill(0,100,0,80);
    translate((nya.pos2d[0][0]+nya.pos2d[1][0]+nya.pos2d[2][0]+nya.pos2d[3][0])/4+50,(nya.pos2d[0][1]+nya.pos2d[1][1]+nya.pos2d[2][1]+nya.pos2d[3][1])/4+50);
    text("TRANS "+trans2text(nya.trans.x)+","+trans2text(nya.trans.y)+","+trans2text(nya.trans.z),0,0);
    text("ANGLE "+angle2text(nya.angle.x)+","+angle2text(nya.angle.y)+","+angle2text(nya.angle.z),0,15);
    popMatrix();    
    //マーカの位置を描画
    drawMarkerPos(nya.pos2d);
    hint(ENABLE_DEPTH_TEST);
    
    PGraphicsOpenGL pgl = (PGraphicsOpenGL) g;
    nya.beginTransform(pgl);//マーカ座標系での描画を開始する。
    //ここからマーカ座標系
    stroke(0);
    //translate(0,0,20);
    translate(0,0,2);
    fill(0,0,255);
    
    //box(40);
    image(cam,-40,-40,80,80);
    //sphere(40);
    nya.endTransform();//マーカ座標系での描画を終了する。（必ず呼んで！）
  }
  else
  {
   fail++; 
  }
}



void help()
{
  
}


  void draw()
  {
   
   drawAR();
   if (fail>50)
   {
      image(help,0,0);
   }


  }
  
  


