/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import org.gstreamer.Bus;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GstObject;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.elements.RGBDataSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSPlayer
extends PImage
implements PConstants {
    protected Method playerEventMethod;
    protected String filename;
    protected boolean play;
    protected boolean repeat;
    protected boolean available;
    protected boolean firstFrame;
    protected int fps;
    protected int movieWidth;
    protected int movieHeight;
    protected IntBuffer moviePixels;
    protected PlayBin gplayer;

    public GSPlayer(PApplet parent, String filename) {
        this(parent, filename, true, 30);
    }

    public GSPlayer(PApplet parent, String filename, boolean loadVideo) {
        this(parent, filename, loadVideo, 30);
    }

    public GSPlayer(PApplet parent, String filename, boolean loadVideo, int ifps) {
        block15: {
            super(1, 1, 1);
            this.firstFrame = true;
            this.fps = 0;
            this.parent = parent;
            this.gplayer = null;
            GSVideo.init();
            boolean filefound = false;
            try {
                File file;
                try {
                    file = new File(parent.dataPath(filename));
                    if (file.exists()) {
                        this.gplayer = new PlayBin("GSPlayer");
                        this.gplayer.setInputFile(file);
                        filefound = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.gplayer != null) break block15;
                try {
                    file = new File(filename);
                    if (file.exists()) {
                        this.gplayer = new PlayBin("GSPlayer");
                        this.gplayer.setInputFile(file);
                        filefound = true;
                    }
                }
                catch (Exception exception) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.gplayer == null) {
            parent.die("Could not load media file " + filename, null);
        }
        try {
            this.filename = filename;
            this.fps = ifps;
            parent.registerDispose((Object)this);
            try {
                this.playerEventMethod = parent.getClass().getMethod("playerEvent", GSPlayer.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loadVideo) {
                RGBDataSink videoSink = new RGBDataSink("rgb", new RGBDataSink.Listener(){

                    public void rgbFrame(int w, int h, IntBuffer buffer) {
                        GSPlayer.this.invokeEvent(w, h, buffer);
                    }
                });
                this.gplayer.setVideoSink((Element)videoSink);
            } else {
                this.gplayer.setVideoSink(ElementFactory.make((String)"fakesink", (String)"videosink"));
            }
            this.gplayer.getBus().connect(new Bus.EOS(){

                public void endOfStream(GstObject element) {
                    GSPlayer.this.eosEvent();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float duration() {
        float sec = this.gplayer.queryDuration().toSeconds();
        float nanosec = this.gplayer.queryDuration().getNanoSeconds();
        return sec + this.nanoSecToSecFrac(nanosec);
    }

    public void frameRate(int ifps) {
    }

    public void speed(float rate) {
    }

    public float time() {
        float sec = this.gplayer.queryPosition().toSeconds();
        float nanosec = this.gplayer.queryPosition().getNanoSeconds();
        return sec + this.nanoSecToSecFrac(nanosec);
    }

    public void jump(float where) {
        this.gplayer.seek(ClockTime.fromNanos((long)this.secToNanoLong(where)));
    }

    public boolean available() {
        return this.available;
    }

    public void play() {
        this.play = true;
        this.gplayer.play();
    }

    public void loop() {
        this.play = true;
        this.repeat = true;
        this.gplayer.play();
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.play = false;
        this.gplayer.pause();
    }

    public void stop() {
        this.play = false;
        this.goToBeginning();
        this.gplayer.stop();
    }

    public void read() {
        if (this.firstFrame) {
            super.init(this.movieWidth, this.movieHeight, 1);
            this.loadPixels();
            this.firstFrame = false;
        }
        this.moviePixels.get(this.pixels);
        this.updatePixels();
        this.available = false;
    }

    public void goToBeginning() {
        this.gplayer.seek(ClockTime.fromNanos((long)0L));
    }

    public void volume(double v) {
        if (this.play) {
            this.gplayer.setVolume(v);
        }
    }

    public void volume(int v) {
        if (this.play) {
            this.gplayer.setVolume((double)v);
        }
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        }
    }

    protected void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.movieWidth = w;
        this.movieHeight = h;
        this.moviePixels = buffer;
        if (this.play && this.playerEventMethod != null) {
            try {
                this.playerEventMethod.invoke((Object)this.parent, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling playerEvent() for " + this.filename);
                e.printStackTrace();
                this.playerEventMethod = null;
            }
        }
    }

    protected float nanoSecToSecFrac(float nanosec) {
        int i = 0;
        while (i < 3) {
            nanosec = (float)((double)nanosec / 1000.0);
            ++i;
        }
        return nanosec;
    }

    protected long secToNanoLong(float sec) {
        Float f = new Float((double)sec * 1.0E9);
        return f.longValue();
    }

    public void dispose() {
        this.stop();
    }
}

