/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.rotmatrix;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARRotMatrix_ARToolKit
extends NyARRotMatrix {
    protected final NyARDoublePoint3d _angle = new NyARDoublePoint3d();

    public NyARRotMatrix_ARToolKit(NyARPerspectiveProjectionMatrix i_matrix) throws NyARException {
        super(i_matrix);
    }

    public final void initRotBySquare(NyARLinear[] i_linear, NyARDoublePoint2d[] i_sqvertex) throws NyARException {
        super.initRotBySquare(i_linear, i_sqvertex);
        this.updateAngleFromMatrix();
    }

    public final NyARDoublePoint3d refAngle() {
        return this._angle;
    }

    public void setAngle(double i_x, double i_y, double i_z) {
        double sina = Math.sin(i_x);
        double cosa = Math.cos(i_x);
        double sinb = Math.sin(i_y);
        double cosb = Math.cos(i_y);
        double sinc = Math.sin(i_z);
        double cosc = Math.cos(i_z);
        double CACA = cosa * cosa;
        double SASA = sina * sina;
        double SACA = sina * cosa;
        double SASB = sina * sinb;
        double CASB = cosa * sinb;
        double SACACB = SACA * cosb;
        this.m00 = CACA * cosb * cosc + SASA * cosc + SACACB * sinc - SACA * sinc;
        this.m01 = -CACA * cosb * sinc - SASA * sinc + SACACB * cosc - SACA * cosc;
        this.m02 = CASB;
        this.m10 = SACACB * cosc - SACA * cosc + SASA * cosb * sinc + CACA * sinc;
        this.m11 = -SACACB * sinc + SACA * sinc + SASA * cosb * cosc + CACA * cosc;
        this.m12 = SASB;
        this.m20 = -CASB * cosc - SASB * sinc;
        this.m21 = CASB * sinc - SASB * cosc;
        this.m22 = cosb;
        this.updateAngleFromMatrix();
    }

    private final void updateAngleFromMatrix() {
        double c;
        double a;
        double cosb = this.m22 > 1.0 ? 1.0 : (this.m22 < -1.0 ? -1.0 : this.m22);
        double b = Math.acos(cosb);
        double sinb = Math.sin(b);
        double rot02 = this.m02;
        double rot12 = this.m12;
        if (b >= 1.0E-6 || b <= -1.0E-6) {
            double cosa = rot02 / sinb;
            double sina = rot12 / sinb;
            if (cosa > 1.0) {
                cosa = 1.0;
                sina = 0.0;
            }
            if (cosa < -1.0) {
                cosa = -1.0;
                sina = 0.0;
            }
            if (sina > 1.0) {
                sina = 1.0;
                cosa = 0.0;
            }
            if (sina < -1.0) {
                sina = -1.0;
                cosa = 0.0;
            }
            a = Math.acos(cosa);
            if (sina < 0.0) {
                a = -a;
            }
            double tmp = rot02 * rot02 + rot12 * rot12;
            double sinc = (this.m21 * rot02 - this.m20 * rot12) / tmp;
            double cosc = -(rot02 * this.m20 + rot12 * this.m21) / tmp;
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        } else {
            b = 0.0;
            a = 0.0;
            cosb = 1.0;
            double cosa = 1.0;
            sinb = 0.0;
            double sina = 0.0;
            double cosc = this.m00;
            double sinc = this.m01;
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        }
        this._angle.x = a;
        this._angle.y = b;
        this._angle.z = c;
    }
}

