/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Library;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.HashMap;
import org.gstreamer.GObject;
import org.gstreamer.lowlevel.GNative;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GTypeMapper;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;
import org.gstreamer.lowlevel.annotations.Invalidate;

public interface GValueAPI
extends Library {
    public static final GValueAPI gvalue = GNative.loadLibrary("gobject-2.0", GValueAPI.class, new HashMap<String, Object>(){
        {
            this.put("type-mapper", new GTypeMapper());
        }
    });

    public GValue g_value_init(GValue var1, GType var2);

    public GValue g_value_reset(GValue var1);

    public void g_value_unset(GValue var1);

    public void g_value_set_char(GValue var1, byte var2);

    public byte g_value_get_char(GValue var1);

    public void g_value_set_uchar(GValue var1, byte var2);

    public byte g_value_get_uchar(GValue var1);

    public void g_value_set_boolean(GValue var1, boolean var2);

    public boolean g_value_get_boolean(GValue var1);

    public void g_value_set_int(GValue var1, int var2);

    public int g_value_get_int(GValue var1);

    public void g_value_set_uint(GValue var1, int var2);

    public int g_value_get_uint(GValue var1);

    public void g_value_set_long(GValue var1, NativeLong var2);

    public NativeLong g_value_get_long(GValue var1);

    public void g_value_set_ulong(GValue var1, NativeLong var2);

    public NativeLong g_value_get_ulong(GValue var1);

    public void g_value_set_int64(GValue var1, long var2);

    public long g_value_get_int64(GValue var1);

    public void g_value_set_uint64(GValue var1, long var2);

    public long g_value_get_uint64(GValue var1);

    public void g_value_set_float(GValue var1, float var2);

    public float g_value_get_float(GValue var1);

    public void g_value_set_double(GValue var1, double var2);

    public double g_value_get_double(GValue var1);

    public void g_value_set_enum(GValue var1, int var2);

    public int g_value_get_enum(GValue var1);

    public void g_value_set_string(GValue var1, String var2);

    public void g_value_set_static_string(GValue var1, String var2);

    public String g_value_get_string(GValue var1);

    public boolean g_value_type_compatible(GType var1, GType var2);

    public boolean g_value_type_transformable(GType var1, GType var2);

    public boolean g_value_transform(GValue var1, GValue var2);

    public void g_value_set_object(GValue var1, GObject var2);

    public void g_value_take_object(GValue var1, @Invalidate GObject var2);

    public GObject g_value_get_object(GValue var1);

    @CallerOwnsReturn
    public GObject g_value_dup_object(GValue var1);

    public GValue g_value_array_get_nth(GValueArray var1, int var2);

    public Pointer g_value_array_new(int var1);

    public void g_value_array_free(GValueArray var1);

    public Pointer g_value_array_copy(GValueArray var1);

    public Pointer g_value_array_prepend(GValueArray var1, GValue var2);

    public Pointer g_value_array_append(GValueArray var1, GValue var2);

    public Pointer g_value_array_insert(GValueArray var1, int var2, GValue var3);

    public Pointer g_value_array_remove(GValueArray var1, int var2);

    public static class GValue
    extends Structure {
        public volatile GType g_type;
        public volatile GValueData[] data = new GValueData[2];

        public GValue() {
        }

        public GValue(Pointer ptr) {
            this.useMemory(ptr);
            this.read();
        }

        public static class GValueData
        extends Union {
            public volatile int v_int;
            public volatile long v_long;
            public volatile long v_int64;
            public volatile float v_float;
            public volatile double v_double;
            public volatile Pointer v_pointer;
        }
    }

    public static class GValueArray
    extends Structure {
        public volatile int n_values;
        public volatile GValue[] values;
        public volatile int n_prealloced;

        public GValueArray() {
            this.clear();
        }

        public GValueArray(Pointer pointer) {
            int[] intArray = pointer.getIntArray(0L, 3);
            this.n_values = intArray[0];
            this.n_prealloced = intArray[2];
            Pointer pointerToArray = pointer.getPointer(4L);
            GValue val = new GValue(pointerToArray);
            this.values = (GValue[])val.toArray(this.n_values);
        }

        private static GValueArray valueOf(Pointer ptr) {
            return ptr != null ? new GValueArray(ptr) : null;
        }

        public int getNValues() {
            return this.n_values;
        }

        public Object getValue(int i) {
            GType valType = this.values[i].g_type;
            if (valType.equals((Object)GType.INT)) {
                return new Integer(gvalue.g_value_get_int(this.values[i]));
            }
            if (valType.equals((Object)GType.UINT)) {
                return new Integer(gvalue.g_value_get_uint(this.values[i]));
            }
            if (valType.equals((Object)GType.CHAR)) {
                return new Byte(gvalue.g_value_get_char(this.values[i]));
            }
            if (valType.equals((Object)GType.UCHAR)) {
                return new Byte(gvalue.g_value_get_uchar(this.values[i]));
            }
            if (valType.equals((Object)GType.LONG)) {
                return new Long(gvalue.g_value_get_long(this.values[i]).longValue());
            }
            if (valType.equals((Object)GType.ULONG)) {
                return new Long(gvalue.g_value_get_ulong(this.values[i]).longValue());
            }
            if (valType.equals((Object)GType.INT64)) {
                return new Long(gvalue.g_value_get_int64(this.values[i]));
            }
            if (valType.equals((Object)GType.UINT64)) {
                return new Long(gvalue.g_value_get_uint64(this.values[i]));
            }
            if (valType.equals((Object)GType.BOOLEAN)) {
                return new Boolean(gvalue.g_value_get_boolean(this.values[i]));
            }
            if (valType.equals((Object)GType.FLOAT)) {
                return new Float(gvalue.g_value_get_float(this.values[i]));
            }
            if (valType.equals((Object)GType.DOUBLE)) {
                return new Double(gvalue.g_value_get_double(this.values[i]));
            }
            if (valType.equals((Object)GType.STRING)) {
                return gvalue.g_value_get_string(this.values[i]);
            }
            if (valType.equals((Object)GType.OBJECT)) {
                return gvalue.g_value_get_object(this.values[i]);
            }
            return null;
        }
    }
}

