/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.File;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.elements.PlayBin;

public class AudioPlayerMetadata {
    public static void main(String[] args) {
        if ((args = Gst.init("AudioPlayerMetadata", args)).length < 1) {
            System.out.println("Usage: AudioPlayer <file to play>");
            System.exit(1);
        }
        PlayBin playbin = new PlayBin("AudioPlayer");
        playbin.setVideoSink(ElementFactory.make("fakesink", "videosink"));
        playbin.setInputFile(new File(args[0]));
        playbin.getBus().connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                for (String tagName : tagList.getTagNames()) {
                    for (Object tagData : tagList.getValues(tagName)) {
                        System.out.printf("[%s]=%s\n", tagName, tagData);
                    }
                }
            }
        });
        playbin.setState(State.PLAYING);
        Gst.main();
        playbin.setState(State.NULL);
    }
}

