/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.Message;
import org.gstreamer.MessageType;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.TagMergeMode;
import org.gstreamer.TestPipe;
import org.gstreamer.lowlevel.GstElementAPI;
import org.gstreamer.lowlevel.GstMessageAPI;
import org.gstreamer.lowlevel.GstTagListAPI;
import org.gstreamer.message.BufferingMessage;
import org.gstreamer.message.DurationMessage;
import org.gstreamer.message.EOSMessage;
import org.gstreamer.message.LatencyMessage;
import org.gstreamer.message.SegmentDoneMessage;
import org.gstreamer.message.StateChangedMessage;
import org.gstreamer.message.TagMessage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MessageTest {
    private static final long DURATION = 1234000000L;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("BusTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void gst_message_new_eos() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_eos(fakesink);
        Assert.assertTrue((String)"gst_message_new_eos did not return an instance of EOSMessage", (boolean)(msg instanceof EOSMessage));
    }

    @Test
    public void EOSMessage_getSource() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_eos(fakesink);
        Assert.assertEquals((String)"Wrong source in message", (Object)fakesink, (Object)msg.getSource());
    }

    @Test
    public void postEOS() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::eos", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.sink, new EOSMessage(pipe.sink));
        pipe.run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.EOS, (Object)msg.getType());
        Assert.assertTrue((String)"Message not intance of EOSMessage", (boolean)(msg instanceof EOSMessage));
        Assert.assertEquals((String)"Wrong source in message", (Object)pipe.pipe, (Object)msg.getSource());
        pipe.dispose();
    }

    @Test
    public void gst_message_new_percent() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_buffering(fakesink, 55);
        Assert.assertTrue((String)"gst_message_new_eos did not return an instance of BufferingMessage", (boolean)(msg instanceof BufferingMessage));
    }

    @Test
    public void BufferingMessage_getPercent() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        BufferingMessage msg = (BufferingMessage)GstMessageAPI.INSTANCE.gst_message_new_buffering(fakesink, 55);
        Assert.assertEquals((String)"Wrong source in message", (long)55L, (long)msg.getPercent());
    }

    @Test
    public void postBufferingMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::buffering", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        int PERCENT = 55;
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.sink, new BufferingMessage(pipe.src, 55));
        pipe.run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.BUFFERING, (Object)msg.getType());
        Assert.assertTrue((String)"Message not instance of BufferingMessage", (boolean)(msg instanceof BufferingMessage));
        Assert.assertEquals((String)"Wrong source in message", (Object)pipe.src, (Object)msg.getSource());
        Assert.assertEquals((String)"Wrong percent value in message", (long)55L, (long)((BufferingMessage)msg).getPercent());
        pipe.dispose();
    }

    @Test
    public void gst_message_new_duration() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_duration(fakesink, Format.TIME, 1234000000L);
        Assert.assertTrue((String)"gst_message_new_duration did not return an instance of DurationMessage", (boolean)(msg instanceof DurationMessage));
    }

    @Test
    public void DurationMessage_getDuration() {
        Element fakesink = ElementFactory.make("fakesink", "sink");
        DurationMessage msg = (DurationMessage)GstMessageAPI.INSTANCE.gst_message_new_duration(fakesink, Format.TIME, 1234000000L);
        Assert.assertEquals((String)"Wrong duration in message", (long)1234000000L, (long)msg.getDuration());
    }

    @Test
    public void postDurationMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::duration", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.src, new DurationMessage(pipe.src, Format.TIME, 1234000000L));
        pipe.play().run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.DURATION, (Object)msg.getType());
        Assert.assertTrue((String)"Message not instance of EOSMessage", (boolean)(msg instanceof DurationMessage));
        Assert.assertEquals((String)"Wrong source in message", (Object)pipe.src, (Object)msg.getSource());
        Assert.assertEquals((String)"Wrong duration value in message", (long)1234000000L, (long)((DurationMessage)msg).getDuration());
        Assert.assertEquals((String)"Wrong duration format in message", (Object)Format.TIME, (Object)((DurationMessage)msg).getFormat());
        pipe.dispose();
    }

    @Test
    public void gst_message_new_tag() {
        Element src = ElementFactory.make("fakesrc", "src");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_tag(src, new TagList());
        Assert.assertTrue((String)"gst_message_new_tag did not return an instance of TagMessage", (boolean)(msg instanceof TagMessage));
    }

    @Test
    public void TagMessage_getTagList() {
        Element src = ElementFactory.make("fakesrc", "src");
        TagList tl = new TagList();
        String MAGIC = "fubar";
        GstTagListAPI.INSTANCE.gst_tag_list_add(tl, TagMergeMode.APPEND, "artist", "fubar");
        TagMessage msg = (TagMessage)GstMessageAPI.INSTANCE.gst_message_new_tag(src, tl);
        tl = msg.getTagList();
        Assert.assertEquals((String)"Wrong artist in tag list", (Object)"fubar", (Object)tl.getString("artist", 0));
    }

    @Test
    public void gst_message_new_state_changed() {
        Element src = ElementFactory.make("fakesrc", "src");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_state_changed(src, State.READY, State.PLAYING, State.VOID_PENDING);
        Assert.assertTrue((String)"gst_message_new_state_changed did not return an instance of StateChangedMessage", (boolean)(msg instanceof StateChangedMessage));
    }

    @Test
    public void constructStateChanged() {
        Element src = ElementFactory.make("fakesrc", "src");
        new StateChangedMessage(src, State.READY, State.PLAYING, State.VOID_PENDING);
    }

    @Test
    public void StateChanged_get() {
        Element src = ElementFactory.make("fakesrc", "src");
        StateChangedMessage msg = (StateChangedMessage)GstMessageAPI.INSTANCE.gst_message_new_state_changed(src, State.READY, State.PLAYING, State.VOID_PENDING);
        Assert.assertEquals((String)"Wrong old state", (Object)State.READY, (Object)msg.getOldState());
        Assert.assertEquals((String)"Wrong new state", (Object)State.PLAYING, (Object)msg.getNewState());
        Assert.assertEquals((String)"Wrong pending state", (Object)State.VOID_PENDING, (Object)msg.getPendingState());
    }

    @Test
    public void postStateChangedMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::state-changed", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.src, new StateChangedMessage(pipe.src, State.READY, State.PLAYING, State.VOID_PENDING));
        pipe.run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.STATE_CHANGED, (Object)msg.getType());
        StateChangedMessage smsg = (StateChangedMessage)msg;
        Assert.assertEquals((String)"Wrong old state", (Object)State.READY, (Object)smsg.getOldState());
        Assert.assertEquals((String)"Wrong new state", (Object)State.PLAYING, (Object)smsg.getNewState());
        Assert.assertEquals((String)"Wrong pending state", (Object)State.VOID_PENDING, (Object)smsg.getPendingState());
        pipe.dispose();
    }

    @Test
    public void gst_message_new_segment_done() {
        Element src = ElementFactory.make("fakesrc", "src");
        Message msg = GstMessageAPI.INSTANCE.gst_message_new_segment_done(src, Format.TIME, -559038737L);
        Assert.assertTrue((String)"gst_message_new_segment_done did not return an instance of SegmentDoneMessage", (boolean)(msg instanceof SegmentDoneMessage));
    }

    @Test
    public void constructSegmentDone() {
        Element src = ElementFactory.make("fakesrc", "src");
        new SegmentDoneMessage(src, Format.TIME, -559038737L);
    }

    @Test
    public void parseSegmentDone() {
        Element src = ElementFactory.make("fakesrc", "src");
        SegmentDoneMessage msg = (SegmentDoneMessage)GstMessageAPI.INSTANCE.gst_message_new_segment_done(src, Format.TIME, -559038737L);
        Assert.assertEquals((String)"Wrong format", (Object)Format.TIME, (Object)msg.getFormat());
        Assert.assertEquals((String)"Wrong position", (long)-559038737L, (long)msg.getPosition());
    }

    @Test
    public void postSegmentDoneMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::segment-done", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        int POSITION = -559038737;
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.src, new SegmentDoneMessage(pipe.src, Format.TIME, -559038737L));
        pipe.run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.SEGMENT_DONE, (Object)msg.getType());
        SegmentDoneMessage smsg = (SegmentDoneMessage)msg;
        Assert.assertEquals((String)"Wrong format", (Object)Format.TIME, (Object)smsg.getFormat());
        Assert.assertEquals((String)"Wrong position", (long)-559038737L, (long)smsg.getPosition());
        pipe.dispose();
    }

    @Test
    public void postLatencyMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference<Object> signalMessage = new AtomicReference<Object>(null);
        pipe.getBus().connect("message::latency", new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalMessage.set(msg);
                pipe.quit();
            }
        });
        GstElementAPI.INSTANCE.gst_element_post_message(pipe.src, new LatencyMessage(pipe.src));
        pipe.run();
        Message msg = signalMessage.get();
        Assert.assertNotNull((String)"No message available on bus", (Object)msg);
        Assert.assertEquals((String)"Wrong message type", (Object)MessageType.LATENCY, (Object)msg.getType());
        LatencyMessage smsg = (LatencyMessage)msg;
        pipe.dispose();
    }
}

