/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.GError;
import org.gstreamer.GstException;
import org.gstreamer.NativeArgs;
import org.gstreamer.Version;
import org.gstreamer.glib.MainContextExecutorService;
import org.gstreamer.lowlevel.GMainContext;
import org.gstreamer.lowlevel.GstAPI;

public final class Gst {
    static Logger logger = Logger.getLogger(Gst.class.getName());
    private static ScheduledExecutorService executorService;
    private static volatile CountDownLatch quit;
    private static GMainContext mainContext;
    private static boolean useDefaultContext;
    private static final AtomicInteger initCount;
    private static List<Runnable> shutdownTasks;
    private static final ThreadFactory threadFactory;

    static {
        quit = new CountDownLatch(1);
        useDefaultContext = false;
        initCount = new AtomicInteger(0);
        shutdownTasks = Collections.synchronizedList(new ArrayList());
        threadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            private ThreadGroup getThreadGroup() {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                try {
                    Class<?> atgClass = Class.forName("sun.applet.AppletThreadGroup");
                    return atgClass.isInstance(tg) ? tg.getParent() : null;
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public Thread newThread(Runnable task) {
                String name = "gstreamer service thread " + this.counter.incrementAndGet();
                Thread t = new Thread(this.getThreadGroup(), task, name);
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        };
    }

    private Gst() {
    }

    public static Version getVersion() {
        long[] major = new long[1];
        long[] minor = new long[1];
        long[] micro = new long[1];
        long[] nano = new long[1];
        GstAPI.gst.gst_version(major, minor, micro, nano);
        return new Version(major[0], minor[0], micro[0], nano[0]);
    }

    public static String getVersionString() {
        return GstAPI.gst.gst_version_string();
    }

    public static Executor getExecutor() {
        return Gst.getScheduledExecutorService();
    }

    public static ExecutorService getExecutorService() {
        return Gst.getScheduledExecutorService();
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return executorService;
    }

    public static void quit() {
        quit.countDown();
    }

    public static void main() {
        try {
            try {
                CountDownLatch latch = quit;
                if (latch != null) {
                    latch.await();
                }
            }
            catch (InterruptedException interruptedException) {
                quit = new CountDownLatch(1);
            }
        }
        finally {
            quit = new CountDownLatch(1);
        }
    }

    public static void invokeLater(Runnable task) {
        Gst.getExecutor().execute(task);
    }

    public static void invokeAndWait(Runnable task) {
        try {
            Gst.getExecutorService().submit(task).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static GMainContext getMainContext() {
        return mainContext;
    }

    public static final void init() throws GstException {
        Gst.init("unknown", new String[0]);
    }

    public static final synchronized String[] init(String progname, String[] args) throws GstException {
        if (initCount.getAndIncrement() > 0) {
            return args;
        }
        NativeArgs argv = new NativeArgs(progname, args);
        Logger.getLogger("org.gstreamer").setLevel(Level.WARNING);
        Pointer[] error = new Pointer[1];
        if (!GstAPI.gst.gst_init_check(argv.argcRef, argv.argvRef, error)) {
            initCount.decrementAndGet();
            throw new GstException(new GError(new GstAPI.GErrorStruct(error[0])));
        }
        logger.fine("after gst_init, argc=" + argv.argcRef.getValue());
        if (useDefaultContext) {
            mainContext = GMainContext.getDefaultContext();
            executorService = new MainContextExecutorService(mainContext);
        } else {
            mainContext = new GMainContext();
            executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        }
        quit = new CountDownLatch(1);
        return argv.toStringArray();
    }

    public static final synchronized void deinit() {
        if (initCount.decrementAndGet() > 0) {
            return;
        }
        Object[] objectArray = shutdownTasks.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object task = objectArray[n2];
            ((Runnable)task).run();
            ++n2;
        }
        executorService.shutdown();
        Gst.quit();
        try {
            if (!executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mainContext = null;
        System.gc();
        GstAPI.gst.gst_deinit();
    }

    public static void addStaticShutdownTask(Runnable task) {
        shutdownTasks.add(task);
    }

    public static void setUseDefaultContext(boolean useDefault) {
        useDefaultContext = useDefault;
    }
}

