/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.gstreamer.ClockTime;
import org.gstreamer.Event;
import org.gstreamer.EventType;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.SeekType;
import org.gstreamer.Structure;
import org.gstreamer.TagList;
import org.gstreamer.event.BufferSizeEvent;
import org.gstreamer.event.EOSEvent;
import org.gstreamer.event.FlushStartEvent;
import org.gstreamer.event.FlushStopEvent;
import org.gstreamer.event.LatencyEvent;
import org.gstreamer.event.NewSegmentEvent;
import org.gstreamer.event.QOSEvent;
import org.gstreamer.event.SeekEvent;
import org.gstreamer.event.TagEvent;
import org.gstreamer.lowlevel.GstEventAPI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("EventTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    public boolean waitGC(WeakReference<? extends Object> ref) throws InterruptedException {
        System.gc();
        int i = 0;
        while (ref.get() != null && i < 20) {
            Thread.sleep(10L);
            System.gc();
            ++i;
        }
        return ref.get() == null;
    }

    @Test
    public void verifyFlags() {
        EventType[] types;
        EventType[] eventTypeArray = types = EventType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EventType t = eventTypeArray[n2];
            int flags = GstEventAPI.INSTANCE.gst_event_type_get_flags(t);
            Assert.assertEquals((String)"Incorrect flags", (long)flags, (long)(t.intValue() & 0xF));
            ++n2;
        }
    }

    @Test
    public void createEOSEvent() throws Exception {
        new EOSEvent();
    }

    @Test
    public void createFlushStartEvent() throws Exception {
        new FlushStartEvent();
    }

    @Test
    public void createFlushStopEvent() throws Exception {
        new FlushStopEvent();
    }

    @Test
    public void createLatencyEvent() throws Exception {
        new LatencyEvent(ClockTime.ZERO);
    }

    @Test
    public void createSegmentEvent() throws Exception {
        new NewSegmentEvent(false, 1.0, Format.TIME, 0L, 0L, 0L);
    }

    @Test
    public void gst_event_new_eos() {
        Event eos = GstEventAPI.INSTANCE.gst_event_new_eos();
        Assert.assertNotNull((String)"gst_event_new_eos returned null", (Object)eos);
        Assert.assertTrue((String)"gst_event_new_eos returned a non-EOS event", (boolean)(eos instanceof EOSEvent));
    }

    @Test
    public void gst_event_new_flush_start() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_flush_start();
        Assert.assertNotNull((String)"gst_event_new_flush_start returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_flush_start returned a non-FLUSH_START event", (boolean)(ev instanceof FlushStartEvent));
    }

    @Test
    public void gst_event_new_flush_stop() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_flush_stop();
        Assert.assertNotNull((String)"gst_event_new_flush_stop returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_flush_stop returned a non-FLUSH_STOP event", (boolean)(ev instanceof FlushStopEvent));
    }

    @Test
    public void gst_event_new_latency() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_latency(ClockTime.ZERO);
        Assert.assertNotNull((String)"gst_event_new_latency returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_latency returned a non-LATENCY event", (boolean)(ev instanceof LatencyEvent));
    }

    @Test
    public void gst_event_new_new_segment() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_new_segment(false, 1.0, Format.TIME, 0L, 0L, 0L);
        Assert.assertNotNull((String)"gst_event_new_latency returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_latency returned a non-NEWSEGMENT event", (boolean)(ev instanceof NewSegmentEvent));
    }

    @Test
    public void getLatency() {
        ClockTime MAGIC = ClockTime.valueOf(-559038737L, TimeUnit.NANOSECONDS);
        LatencyEvent ev = new LatencyEvent(MAGIC);
        Assert.assertEquals((String)"Incorrect latency returned", (Object)MAGIC, (Object)ev.getLatency());
    }

    @Test
    public void NewSegment_isUpdate() {
        NewSegmentEvent ev = new NewSegmentEvent(false, 1.0, Format.TIME, 0L, 0L, 0L);
        Assert.assertFalse((String)"Segment should not be an update", (boolean)ev.isUpdate());
        ev = new NewSegmentEvent(true, 1.0, Format.TIME, 0L, 0L, 0L);
        Assert.assertTrue((String)"Segment should be an update", (boolean)ev.isUpdate());
    }

    @Test
    public void NewSegment_getRate() {
        double RATE = -5.59038737E8;
        NewSegmentEvent ev = new NewSegmentEvent(false, -5.59038737E8, Format.TIME, 0L, 0L, 0L);
        Assert.assertEquals((String)"Incorrect rate returned from getRate", (double)-5.59038737E8, (double)ev.getRate(), (double)0.0);
    }

    @Test
    public void NewSegment_getStart() {
        long START = 3735928559L;
        NewSegmentEvent ev = new NewSegmentEvent(false, 0.1, Format.TIME, 3735928559L, -1L, 0L);
        Assert.assertEquals((String)"Incorrect rate returned from getRate", (long)3735928559L, (long)ev.getStart());
    }

    @Test
    public void NewSegment_getStop() {
        long STOP = 3735928559L;
        NewSegmentEvent ev = new NewSegmentEvent(false, 1.0, Format.TIME, 0L, 3735928559L, 0L);
        Assert.assertEquals((String)"Incorrect rate returned from getRate", (long)3735928559L, (long)ev.getEnd());
    }

    @Test
    public void gst_event_new_tag() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_tag(new TagList());
        Assert.assertNotNull((String)"gst_event_new_tag returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_tag returned a non-TAG event", (boolean)(ev instanceof TagEvent));
    }

    @Test
    public void TagEvent_testGC() throws Exception {
        TagEvent ev = new TagEvent(new TagList());
        TagList tl = ev.getTagList();
        WeakReference<TagEvent> evRef = new WeakReference<TagEvent>(ev);
        ev = null;
        Assert.assertFalse((String)"Event ref collected before TagList is unreferenced", (boolean)this.waitGC(evRef));
        tl = null;
        Assert.assertTrue((String)"Event ref not collected after TagList is unreferenced", (boolean)this.waitGC(evRef));
    }

    @Test
    public void Event_testGC() throws Exception {
        LatencyEvent ev = new LatencyEvent(ClockTime.NONE);
        Structure s = ev.getStructure();
        WeakReference<LatencyEvent> evRef = new WeakReference<LatencyEvent>(ev);
        ev = null;
        Assert.assertFalse((String)"Event ref collected before Structure is unreferenced", (boolean)this.waitGC(evRef));
        s = null;
        Assert.assertTrue((String)"Event ref not collected after Structure is unreferenced", (boolean)this.waitGC(evRef));
    }

    @Test
    public void gst_event_new_buffer_size() {
        long MIN = 4660L;
        long MAX = -559038737L;
        boolean ASYNC = false;
        Event ev = GstEventAPI.INSTANCE.gst_event_new_buffer_size(Format.BYTES, 4660L, -559038737L, false);
        Assert.assertNotNull((String)"gst_event_new_buffer_size returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_buffer_size returned a non-BUFFERSIZE event", (boolean)(ev instanceof BufferSizeEvent));
    }

    @Test
    public void BufferSize_getMinimumSize() {
        long MIN = 4660L;
        long MAX = -559038737L;
        boolean ASYNC = false;
        BufferSizeEvent ev = (BufferSizeEvent)GstEventAPI.INSTANCE.gst_event_new_buffer_size(Format.BYTES, 4660L, -559038737L, false);
        Assert.assertEquals((String)"Wrong minimum size stored", (long)4660L, (long)ev.getMinimumSize());
    }

    @Test
    public void BufferSize_getMaximumSize() {
        long MIN = 4660L;
        long MAX = -559038737L;
        boolean ASYNC = false;
        BufferSizeEvent ev = (BufferSizeEvent)GstEventAPI.INSTANCE.gst_event_new_buffer_size(Format.BYTES, 4660L, -559038737L, false);
        Assert.assertEquals((String)"Wrong minimum size stored", (long)-559038737L, (long)ev.getMaximumSize());
    }

    @Test
    public void BufferSize_isAsync() {
        long MIN = 4660L;
        long MAX = -559038737L;
        boolean ASYNC = false;
        BufferSizeEvent ev = (BufferSizeEvent)GstEventAPI.INSTANCE.gst_event_new_buffer_size(Format.BYTES, 4660L, -559038737L, false);
        Assert.assertEquals((String)"Wrong minimum size stored", (Object)false, (Object)ev.isAsync());
        BufferSizeEvent ev2 = (BufferSizeEvent)GstEventAPI.INSTANCE.gst_event_new_buffer_size(Format.BYTES, 4660L, -559038737L, true);
        Assert.assertEquals((String)"Wrong minimum size stored", (Object)true, (Object)ev2.isAsync());
    }

    @Test
    public void gst_event_new_qos() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_qos(0.0, 0L, ClockTime.NONE);
        Assert.assertNotNull((String)"gst_event_new_qos returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_qos returned a non-QOS event", (boolean)(ev instanceof QOSEvent));
    }

    @Test
    public void QOS_getProportion() {
        double PROPORTION = -5.59038737E8;
        QOSEvent ev = new QOSEvent(-5.59038737E8, 0L, ClockTime.ZERO);
        Assert.assertEquals((String)"Wrong proportion", (double)-5.59038737E8, (double)ev.getProportion(), (double)0.0);
    }

    public void QOS_getDifference() {
        long DIFF = -559038737L;
        QOSEvent ev = new QOSEvent(0.0, DIFF, ClockTime.ZERO);
        Assert.assertEquals((String)"Wrong difference", (long)DIFF, (long)ev.getDifference());
    }

    @Test
    public void QOS_getTimestamp() {
        ClockTime STAMP = ClockTime.valueOf(-559038737L, TimeUnit.NANOSECONDS);
        QOSEvent ev = new QOSEvent(0.0, 0L, STAMP);
        Assert.assertEquals((String)"Wrong timestamp", (Object)STAMP, (Object)ev.getTimestamp());
    }

    @Test
    public void gst_event_new_seek() {
        Event ev = GstEventAPI.INSTANCE.gst_event_new_seek(1.0, Format.TIME, 0, SeekType.SET, 0L, SeekType.SET, 0L);
        Assert.assertNotNull((String)"gst_event_new_seek returned null", (Object)ev);
        Assert.assertTrue((String)"gst_event_new_seek returned a non-SEEK event", (boolean)(ev instanceof SeekEvent));
    }

    @Test
    public void Seek_getFormat() {
        Format[] formatArray = new Format[]{Format.TIME, Format.BYTES};
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format FORMAT = formatArray[n2];
            SeekEvent ev = new SeekEvent(1.0, FORMAT, 0, SeekType.SET, 0L, SeekType.SET, 0L);
            Assert.assertEquals((String)"Wrong format in SeekEvent", (Object)FORMAT, (Object)ev.getFormat());
            ++n2;
        }
    }

    @Test
    public void Seek_getStartType() {
        SeekType[] seekTypeArray = new SeekType[]{SeekType.CUR, SeekType.SET, SeekType.END};
        int n = seekTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeekType TYPE = seekTypeArray[n2];
            SeekEvent ev = new SeekEvent(1.0, Format.TIME, 0, TYPE, 0L, SeekType.NONE, 0L);
            Assert.assertEquals((String)"Wrong startType in SeekEvent", (Object)((Object)TYPE), (Object)((Object)ev.getStartType()));
            ++n2;
        }
    }

    @Test
    public void Seek_getStopType() {
        SeekType[] seekTypeArray = new SeekType[]{SeekType.CUR, SeekType.SET, SeekType.END};
        int n = seekTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeekType TYPE = seekTypeArray[n2];
            SeekEvent ev = new SeekEvent(1.0, Format.TIME, 0, SeekType.NONE, 0L, TYPE, 0L);
            Assert.assertEquals((String)"Wrong stopType in SeekEvent", (Object)((Object)TYPE), (Object)((Object)ev.getStopType()));
            ++n2;
        }
    }

    @Test
    public void Seek_getStart() {
        long START = -559038737L;
        SeekEvent ev = new SeekEvent(1.0, Format.TIME, 0, SeekType.SET, -559038737L, SeekType.SET, -1L);
        Assert.assertEquals((String)"Wrong start in SeekEvent", (long)-559038737L, (long)ev.getStart());
    }

    @Test
    public void Seek_getStop() {
        long STOP = -559038737L;
        SeekEvent ev = new SeekEvent(1.0, Format.TIME, 0, SeekType.SET, 0L, SeekType.SET, -559038737L);
        Assert.assertEquals((String)"Wrong stop in SeekEvent", (long)-559038737L, (long)ev.getStop());
    }

    @Test
    public void Seek_rateZero() {
        try {
            new SeekEvent(0.0, Format.TIME, 0, SeekType.SET, 0L, SeekType.SET, -1L);
            Assert.fail((String)"A rate of 0.0 should throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

