/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import org.gstreamer.Caps;
import org.gstreamer.Gst;
import org.gstreamer.Structure;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CapsTest {
    private static final String non_simple_caps_string = "video/x-raw-yuv, format=(fourcc)I420, framerate=(fraction)[ 1/100, 100 ], width=(int)[ 16, 4096 ], height=(int)[ 16, 4096 ]; video/x-raw-yuv, format=(fourcc)YUY2, framerate=(fraction)[ 1/100, 100 ], width=(int)[ 16, 4096 ], height=(int)[ 16, 4096 ]; video/x-raw-rgb, bpp=(int)8, depth=(int)8, endianness=(int)1234, framerate=(fraction)[ 1/100, 100 ], width=(int)[ 16, 4096 ], height=(int)[ 16, 4096 ]; video/x-raw-yuv, format=(fourcc){ I420, YUY2, YV12 }, width=(int)[ 16, 4096 ], height=(int)[ 16, 4096 ], framerate=(fraction)[ 1/100, 100 ]";

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("CapsTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void capsMerge() {
        Caps caps1 = new Caps("video/x-raw-rgb, bpp=32, depth=24");
        Caps caps2 = new Caps("video/x-raw-rgb, width=640, height=480");
        caps1.merge(caps2);
        try {
            caps2.toString();
            Assert.fail((String)"merged caps not invalidated");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        boolean widthFound = false;
        boolean heightFound = false;
        int i = 0;
        while (i < caps1.size()) {
            Structure s = caps1.getStructure(i);
            if (s.hasIntField("width")) {
                widthFound = true;
            }
            if (s.hasIntField("height")) {
                heightFound = true;
            }
            ++i;
        }
        Assert.assertTrue((String)"width not appended", (boolean)widthFound);
        Assert.assertTrue((String)"height not appended", (boolean)heightFound);
    }

    @Test
    public void capsAppend() {
        Caps caps1 = new Caps("video/x-raw-rgb, bpp=32, depth=24");
        Caps caps2 = new Caps("video/x-raw-rgb, width=640, height=480");
        caps1.append(caps2);
        try {
            caps2.toString();
            Assert.fail((String)"appended caps not invalidated");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        boolean widthFound = false;
        boolean heightFound = false;
        int i = 0;
        while (i < caps1.size()) {
            Structure s = caps1.getStructure(i);
            if (s.hasIntField("width")) {
                widthFound = true;
            }
            if (s.hasIntField("height")) {
                heightFound = true;
            }
            ++i;
        }
        Assert.assertTrue((String)"width not appended", (boolean)widthFound);
        Assert.assertTrue((String)"height not appended", (boolean)heightFound);
    }

    @Test
    public void simplify() {
        Caps caps = new Caps(non_simple_caps_string);
        Assert.assertNotNull((String)"Caps not created", (Object)caps);
        Assert.assertTrue((String)"Could not simplify caps", (boolean)caps.simplify());
        Assert.assertEquals((String)"Caps not simplified to 2 structures", (long)2L, (long)caps.size());
        Structure s1 = caps.getStructure(0);
        Assert.assertNotNull((String)"Caps.getStructure(0) failed", (Object)s1);
        Structure s2 = caps.getStructure(1);
        Assert.assertNotNull((String)"Caps.getStructure(1) failed", (Object)s2);
        if (!s1.hasName("video/x-raw-rgb")) {
            Structure tmp = s1;
            s1 = s2;
            s2 = tmp;
        }
        Assert.assertTrue((String)"Could not locate video/x-raw-rgb structure", (boolean)s1.hasName("video/x-raw-rgb"));
        Assert.assertEquals((String)"bpp not retrieved", (long)8L, (long)s1.getInteger("bpp"));
        Assert.assertEquals((String)"depth not retrieved", (long)8L, (long)s1.getInteger("depth"));
        Assert.assertTrue((String)"Could not locate video/x-raw-yuv structure", (boolean)s2.hasName("video/x-raw-yuv"));
    }

    @Test
    public void truncate() {
        Caps caps = Caps.fromString(non_simple_caps_string);
        Assert.assertNotNull((String)"Caps.fromString failed", (Object)caps);
        Assert.assertEquals((String)"Incorrect number of structures in caps", (long)4L, (long)caps.size());
        caps.truncate();
        Assert.assertEquals((String)"Caps not truncated", (long)1L, (long)caps.size());
    }

    @Test
    public void mergeANYAndSpecific() {
        Caps c1 = Caps.fromString("audio/x-raw-int,rate=44100");
        Caps c2 = Caps.anyCaps();
        c2.merge(c1);
        Assert.assertEquals((String)"Too many structures in merged caps", (long)0L, (long)c2.size());
        Assert.assertTrue((String)"Merged caps should be ANY", (boolean)c2.isAny());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSpecificAndANY() {
        Caps c2 = Caps.fromString("audio/x-raw-int,rate=44100");
        Caps c1 = Caps.anyCaps();
        c2.merge(c1);
        Assert.assertEquals((String)"Too many structures in merged caps", (long)0L, (long)c2.size());
        Assert.assertTrue((String)"Merged caps should be ANY", (boolean)c2.isAny());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSpecificAndEMPTY() {
        Caps c1 = Caps.fromString("audio/x-raw-int,rate=44100");
        Caps c2 = Caps.emptyCaps();
        c2.merge(c1);
        Assert.assertEquals((String)"Wrong number of structures in merged structure", (long)1L, (long)c2.size());
        Assert.assertFalse((String)"Merged caps should not be empty", (boolean)c2.isEmpty());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeEMPTYAndSpecific() {
        Caps c2 = Caps.fromString("audio/x-raw-int,rate=44100");
        Caps c1 = Caps.emptyCaps();
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)1L, (long)c2.size());
        Assert.assertFalse((String)"Merged caps should not be empty", (boolean)c2.isEmpty());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSame() {
        Caps c1 = Caps.fromString("audio/x-raw-int,rate=44100,channels=1");
        Caps c2 = Caps.fromString("audio/x-raw-int,rate=44100,channels=1");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)1L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSameWithDifferentOrder() {
        Caps c1 = Caps.fromString("audio/x-raw-int,rate=44100,channels=1");
        Caps c2 = Caps.fromString("audio/x-raw-int,channels=1,rate=44100");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)1L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSameWithBufferData() {
        Caps c1 = Caps.fromString("video/x-foo, data=(buffer)AA");
        Caps c2 = Caps.fromString("video/x-foo, data=(buffer)AABB");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)2L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSameWithBufferDataReversed() {
        Caps c1 = Caps.fromString("video/x-foo, data=(buffer)AABB");
        Caps c2 = Caps.fromString("video/x-foo, data=(buffer)AA");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)2L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSameWithBufferDataSame() {
        Caps c1 = Caps.fromString("video/x-foo, data=(buffer)AA");
        Caps c2 = Caps.fromString("video/x-foo, data=(buffer)AA");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)1L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeDifferentWithBufferDataSame() {
        Caps c1 = Caps.fromString("video/x-foo, data=(buffer)AA");
        Caps c2 = Caps.fromString("video/x-bar, data=(buffer)AA");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)2L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeSubset() {
        Caps c2 = Caps.fromString("audio/x-raw-int,channels=[1,2]");
        Caps c1 = Caps.fromString("audio/x-raw-int,channels=1");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)1L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void mergeNonSubset() {
        Caps c2 = Caps.fromString("audio/x-raw-int,channels=1,rate=44100");
        Caps c1 = Caps.fromString("audio/x-raw-int,channels=[1,2],rate=44100");
        c2.merge(c1);
        Assert.assertEquals((String)"Merged Caps structure count incorrect", (long)2L, (long)c2.size());
        c2.dispose();
        c1.dispose();
    }

    @Test
    public void intersect() {
        Caps c2 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=20");
        Caps c1 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,height=30");
        Caps ci1 = c2.intersect(c1);
        Assert.assertEquals((String)"Intersected Caps structure count incorrect", (long)1L, (long)ci1.size());
        Structure s = ci1.getStructure(0);
        Assert.assertTrue((String)"Incorrect name on intersected structure", (boolean)s.hasName("video/x-raw-yuv"));
        Assert.assertTrue((String)"Intersected structure does not have 'format' field", (boolean)s.hasField("format"));
        Assert.assertTrue((String)"Intersected structure does not have 'width' field", (boolean)s.hasField("width"));
        Assert.assertTrue((String)"Intersected structure does not have 'height' field", (boolean)s.hasField("height"));
        Caps ci2 = c1.intersect(c2);
        Assert.assertEquals((String)"Intersected Caps structure count incorrect", (long)1L, (long)ci2.size());
        s = ci2.getStructure(0);
        Assert.assertTrue((String)"Incorrect name on intersected structure", (boolean)s.hasName("video/x-raw-yuv"));
        Assert.assertTrue((String)"Intersected structure does not have 'format' field", (boolean)s.hasField("format"));
        Assert.assertTrue((String)"Intersected structure does not have 'width' field", (boolean)s.hasField("width"));
        Assert.assertTrue((String)"Intersected structure does not have 'height' field", (boolean)s.hasField("height"));
        Assert.assertTrue((String)"Intersection should be same in both directions", (boolean)ci1.isEqual(ci2));
        c2.dispose();
        c1.dispose();
        ci1.dispose();
        ci2.dispose();
    }

    @Test
    public void intersectUnspecified() {
        Caps c2 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=20");
        Caps c1 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420");
        Caps ci1 = c2.intersect(c1);
        Assert.assertEquals((String)"Intersected Caps structure count incorrect", (long)1L, (long)ci1.size());
        Structure s = ci1.getStructure(0);
        Assert.assertTrue((String)"Incorrect name on intersected structure", (boolean)s.hasName("video/x-raw-yuv"));
        Assert.assertTrue((String)"Intersected structure does not have 'format' field", (boolean)s.hasField("format"));
        Assert.assertTrue((String)"Intersected structure does not have 'width' field", (boolean)s.hasField("width"));
        Caps ci2 = c1.intersect(c2);
        Assert.assertEquals((String)"Intersected Caps structure count incorrect", (long)1L, (long)ci2.size());
        s = ci2.getStructure(0);
        Assert.assertTrue((String)"Incorrect name on intersected structure", (boolean)s.hasName("video/x-raw-yuv"));
        Assert.assertTrue((String)"Intersected structure does not have 'format' field", (boolean)s.hasField("format"));
        Assert.assertTrue((String)"Intersected structure does not have 'width' field", (boolean)s.hasField("width"));
        Assert.assertTrue((String)"Intersection should be same in both directions", (boolean)ci1.isEqual(ci2));
        c2.dispose();
        c1.dispose();
        ci1.dispose();
        ci2.dispose();
    }

    @Test
    public void intersectUnequal() {
        Caps c2 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=20");
        Caps c1 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=30");
        Caps ci1 = c2.intersect(c1);
        Assert.assertTrue((String)"Intersection of unequal caps should be empty", (boolean)ci1.isEmpty());
        Caps ci2 = c1.intersect(c2);
        Assert.assertTrue((String)"Intersection of unequal caps should be empty", (boolean)ci1.isEmpty());
        Assert.assertTrue((String)"Intersection should be same in both directions", (boolean)ci1.isEqual(ci2));
        c2.dispose();
        c1.dispose();
        ci1.dispose();
        ci2.dispose();
    }

    @Test
    public void intersectDifferentType() {
        Caps c2 = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=20");
        Caps c1 = Caps.fromString("video/x-raw-rgb,format=(fourcc)I420,width=20");
        Caps ci1 = c2.intersect(c1);
        Assert.assertTrue((String)"Intersection of different type caps should be empty", (boolean)ci1.isEmpty());
        Caps ci2 = c1.intersect(c2);
        Assert.assertTrue((String)"Intersection of different type caps should be empty", (boolean)ci1.isEmpty());
        Assert.assertTrue((String)"Intersection should be same in both directions", (boolean)ci1.isEqual(ci2));
        c2.dispose();
        c1.dispose();
        ci1.dispose();
        ci2.dispose();
    }
}

